/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.GlobalNamePostProcessor;
import org.mule.runtime.config.spring.MuleConfigurationConfigurator;
import org.mule.runtime.config.spring.MuleContextPostProcessor;
import org.mule.runtime.config.spring.OptionalObjectsController;
import org.mule.runtime.config.spring.SpringConfigurationComponentLocator;
import org.mule.runtime.config.spring.SpringMuleContextServiceConfigurator;
import org.mule.runtime.config.spring.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.MinimalApplicationModelGenerator;
import org.mule.runtime.config.spring.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.spring.dsl.processor.ConfigFile;
import org.mule.runtime.config.spring.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.dsl.processor.SimpleConfigAttribute;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlApplicationServiceRegistry;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.spring.editors.MulePropertyEditorRegistrar;
import org.mule.runtime.config.spring.internal.ImmutableObjectProviderConfiguration;
import org.mule.runtime.config.spring.internal.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.spring.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.spring.processors.ComponentLocatorCreatePostProcessor;
import org.mule.runtime.config.spring.processors.ContextExclusiveInjectorProcessor;
import org.mule.runtime.config.spring.processors.DiscardedOptionalBeanPostProcessor;
import org.mule.runtime.config.spring.processors.LifecycleStatePostProcessor;
import org.mule.runtime.config.spring.processors.MuleInjectorProcessor;
import org.mule.runtime.config.spring.processors.PostRegistrationActionsPostProcessor;
import org.mule.runtime.config.spring.util.LaxInstantiationStrategyWrapper;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.RuntimeConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.Pair;
import org.mule.runtime.core.component.config.ClassLoaderResourceProvider;
import org.mule.runtime.core.component.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.core.component.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.core.internal.registry.DefaultServiceDiscoverer;
import org.mule.runtime.core.registry.MuleRegistryHelper;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.module.extension.internal.config.ExtensionBuildingDefinitionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.w3c.dom.Document;

public class MuleArtifactContext
extends AbstractXmlApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleArtifactContext.class);
    public static final String INNER_BEAN_PREFIX = "(inner bean)";
    protected final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new ComponentBuildingDefinitionRegistry();
    private final OptionalObjectsController optionalObjectsController;
    private final Map<String, String> artifactProperties;
    private final ArtifactDeclaration artifactDeclaration;
    private final XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader;
    private final Optional<ConfigurationProperties> parentConfigurationProperties;
    private final DefaultServiceDiscoverer serviceDiscoverer;
    protected ApplicationModel applicationModel;
    protected MuleContext muleContext;
    private Resource[] artifactConfigResources;
    protected BeanDefinitionFactory beanDefinitionFactory;
    private final ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    protected final XmlApplicationParser xmlApplicationParser;
    private ArtifactType artifactType;
    private List<ComponentIdentifier> componentNotSupportedByNewParsers = new ArrayList<ComponentIdentifier>();
    private SpringConfigurationComponentLocator componentLocator = new SpringConfigurationComponentLocator();
    private List<ObjectProvider> objectProviders = new ArrayList<ObjectProvider>();

    public MuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, Optional<ConfigurationProperties> parentConfigurationProperties) throws BeansException {
        this(muleContext, MuleArtifactContext.convert(artifactConfigResources), artifactDeclaration, optionalObjectsController, parentConfigurationProperties, artifactProperties, artifactType, pluginsClassLoaders);
    }

    public MuleArtifactContext(MuleContext muleContext, Resource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders) {
        Preconditions.checkArgument(optionalObjectsController != null, "optionalObjectsController cannot be null");
        this.muleContext = muleContext;
        this.artifactConfigResources = artifactConfigResources;
        this.optionalObjectsController = optionalObjectsController;
        this.artifactProperties = artifactProperties;
        this.artifactType = artifactType;
        this.artifactDeclaration = artifactDeclaration;
        this.parentConfigurationProperties = parentConfigurationProperties;
        this.xmlConfigurationDocumentLoader = this.newXmlConfigurationDocumentLoader();
        this.serviceDiscoverer = new DefaultServiceDiscoverer(muleContext);
        this.serviceRegistry.lookupProviders(ComponentBuildingDefinitionProvider.class, MuleArtifactContext.class.getClassLoader()).forEach(componentBuildingDefinitionProvider -> {
            if (componentBuildingDefinitionProvider instanceof ExtensionBuildingDefinitionProvider) {
                ((ExtensionBuildingDefinitionProvider)componentBuildingDefinitionProvider).setExtensionModels(muleContext.getExtensionManager() != null ? muleContext.getExtensionManager().getExtensions() : Collections.emptySet());
            }
            componentBuildingDefinitionProvider.init();
            componentBuildingDefinitionProvider.getComponentBuildingDefinitions().forEach(this.componentBuildingDefinitionRegistry::register);
        });
        for (ClassLoader pluginArtifactClassLoader : pluginsClassLoaders) {
            this.serviceRegistry.lookupProviders(ComponentBuildingDefinitionProvider.class, pluginArtifactClassLoader).forEach(componentBuildingDefinitionProvider -> {
                if (!(componentBuildingDefinitionProvider instanceof ExtensionBuildingDefinitionProvider)) {
                    componentBuildingDefinitionProvider.init();
                    componentBuildingDefinitionProvider.getComponentBuildingDefinitions().forEach(this.componentBuildingDefinitionRegistry::register);
                }
            });
        }
        this.xmlApplicationParser = this.createApplicationParser(pluginsClassLoaders);
        this.beanDefinitionFactory = new BeanDefinitionFactory(this.componentBuildingDefinitionRegistry, muleContext.getErrorTypeRepository());
        this.createApplicationModel();
        this.determineIfOnlyNewParsingMechanismCanBeUsed();
    }

    protected XmlConfigurationDocumentLoader newXmlConfigurationDocumentLoader() {
        return XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader();
    }

    private XmlApplicationParser createApplicationParser(List<ClassLoader> pluginsClassLoaders) {
        ExtensionManager extensionManager = this.muleContext.getExtensionManager();
        ServiceRegistry customRegistry = extensionManager != null ? new XmlApplicationServiceRegistry(this.serviceRegistry, DslResolvingContext.getDefault(extensionManager.getExtensions())) : this.serviceRegistry;
        return new XmlApplicationParser(customRegistry, pluginsClassLoaders);
    }

    private void determineIfOnlyNewParsingMechanismCanBeUsed() {
        this.applicationModel.executeOnEveryComponentTree(componentModel -> {
            Optional<ComponentIdentifier> parentIdentifierOptional = Optional.ofNullable(componentModel.getParent()).flatMap(parentComponentModel -> Optional.ofNullable(parentComponentModel.getIdentifier()));
            if (!this.beanDefinitionFactory.hasDefinition(componentModel.getIdentifier(), parentIdentifierOptional)) {
                this.componentNotSupportedByNewParsers.add(componentModel.getIdentifier());
                throw new RuntimeException(String.format("Invalid config '%s'", componentModel.getIdentifier()));
            }
        });
    }

    private void createApplicationModel() {
        try {
            ArtifactConfig artifactConfig = this.resolveArtifactConfig();
            Set<ExtensionModel> extensions = this.muleContext.getExtensionManager() != null ? this.muleContext.getExtensionManager().getExtensions() : Collections.emptySet();
            ClassLoaderResourceProvider externalResourceProvider = new ClassLoaderResourceProvider(this.muleContext.getExecutionClassLoader());
            this.applicationModel = new ApplicationModel(artifactConfig, this.artifactDeclaration, extensions, this.artifactProperties, this.parentConfigurationProperties, Optional.of(this.componentBuildingDefinitionRegistry), true, externalResourceProvider);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    private ArtifactConfig resolveArtifactConfig() throws IOException {
        ArtifactConfig.Builder applicationConfigBuilder = new ArtifactConfig.Builder();
        applicationConfigBuilder.setArtifactProperties(this.artifactProperties);
        ArrayList<Pair<String, InputStream>> initialConfigFiles = new ArrayList<Pair<String, InputStream>>();
        for (Resource artifactConfigResource : this.artifactConfigResources) {
            initialConfigFiles.add(new Pair<String, InputStream>(this.getFilename(artifactConfigResource), artifactConfigResource.getInputStream()));
        }
        ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>();
        this.recursivelyResolveConfigFiles(initialConfigFiles, configFiles).stream().forEach(applicationConfigBuilder::addConfigFile);
        applicationConfigBuilder.setApplicationName(this.muleContext.getConfiguration().getId());
        return applicationConfigBuilder.build();
    }

    private List<ConfigFile> recursivelyResolveConfigFiles(List<Pair<String, InputStream>> configFilesToResolve, List<ConfigFile> alreadyResolvedConfigFiles) {
        DefaultConfigurationPropertiesResolver propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider());
        ImmutableList.Builder resolvedConfigFilesBuilder = ImmutableList.builder().addAll(alreadyResolvedConfigFiles);
        configFilesToResolve.stream().filter(fileNameInputStreamPair -> !alreadyResolvedConfigFiles.stream().anyMatch(configFile -> configFile.getFilename().equals(fileNameInputStreamPair.getFirst()))).forEach(fileNameInputStreamPair -> {
            Document document = this.xmlConfigurationDocumentLoader.loadDocument(this.muleContext.getExtensionManager() == null ? Collections.emptySet() : this.muleContext.getExtensionManager().getExtensions(), (String)fileNameInputStreamPair.getFirst(), (InputStream)fileNameInputStreamPair.getSecond());
            ConfigLine mainConfigLine = this.xmlApplicationParser.parse(document.getDocumentElement()).get();
            ConfigFile configFile = new ConfigFile((String)fileNameInputStreamPair.getFirst(), Arrays.asList(mainConfigLine));
            resolvedConfigFilesBuilder.add((Object)configFile);
            try {
                ((InputStream)fileNameInputStreamPair.getSecond()).close();
            }
            catch (IOException e) {
                throw new MuleRuntimeException(e);
            }
        });
        ImmutableSet.Builder importedFiles = ImmutableSet.builder();
        for (ConfigFile configFile : resolvedConfigFilesBuilder.build()) {
            List<ConfigLine> rootConfigLines = configFile.getConfigLines();
            ConfigLine muleRootElementConfigLine = rootConfigLines.get(0);
            importedFiles.addAll((Iterable)muleRootElementConfigLine.getChildren().stream().filter(configLine -> configLine.getNamespace().equals("mule") && configLine.getIdentifier().equals("import")).map(configLine -> {
                SimpleConfigAttribute fileConfigAttribute = configLine.getConfigAttributes().get("file");
                if (fileConfigAttribute == null) {
                    throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("<import> does not have a file attribute defined. At file '%s', at line %s", configFile.getFilename(), configLine.getLineNumber())));
                }
                return fileConfigAttribute.getValue();
            }).map(value -> (String)propertyResolver.resolveValue((String)value)).filter(fileName -> !alreadyResolvedConfigFiles.stream().anyMatch(solvedConfigFile -> solvedConfigFile.getFilename().equals(fileName))).collect(Collectors.toList()));
        }
        ImmutableSet importedConfigurationFiles = importedFiles.build();
        if (importedConfigurationFiles.isEmpty()) {
            return resolvedConfigFilesBuilder.build();
        }
        List<Pair<String, InputStream>> newConfigFilesToResolved = importedConfigurationFiles.stream().map(importedFileName -> {
            InputStream resourceAsStream = this.muleContext.getExecutionClassLoader().getResourceAsStream((String)importedFileName);
            if (resourceAsStream == null) {
                throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Could not find imported resource '%s'", importedFileName)));
            }
            return new Pair<String, InputStream>((String)importedFileName, resourceAsStream);
        }).collect(Collectors.toList());
        return this.recursivelyResolveConfigFiles(newConfigFilesToResolved, (List<ConfigFile>)resolvedConfigFilesBuilder.build());
    }

    private String getFilename(Resource resource) {
        if (resource instanceof ByteArrayResource) {
            return resource.getDescription();
        }
        return resource.getFilename();
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        this.registerEditors(beanFactory);
        this.registerAnnotationConfigProcessors((BeanDefinitionRegistry)beanFactory);
        this.addBeanPostProcessors(beanFactory, new BeanPostProcessor[]{new MuleContextPostProcessor(this.muleContext), new GlobalNamePostProcessor(), new PostRegistrationActionsPostProcessor((MuleRegistryHelper)this.muleContext.getRegistry(), beanFactory), new DiscardedOptionalBeanPostProcessor(this.optionalObjectsController, (DefaultListableBeanFactory)beanFactory), new LifecycleStatePostProcessor(this.muleContext.getLifecycleManager().getState()), new ComponentLocatorCreatePostProcessor(this.componentLocator)});
        beanFactory.registerSingleton("_muleContext", (Object)this.muleContext);
        this.prepareObjectProviders();
    }

    private void prepareObjectProviders() {
        ImmutableObjectProviderConfiguration providerConfiguration = new ImmutableObjectProviderConfiguration((Map<String, Object>)ImmutableMap.builder().put((Object)"_muleServiceDiscoverer", (Object)this.serviceDiscoverer).build(), this.applicationModel.getConfigurationProperties());
        for (ObjectProvider objectProvider : this.objectProviders) {
            objectProvider.configure(providerConfiguration);
        }
    }

    private void registerObjectFromObjectProviders(ConfigurableListableBeanFactory beanFactory) {
        this.objectProviders.addAll(this.lookObjectProviders());
        ((ObjectProviderAwareBeanFactory)beanFactory).setObjectProviders(this.objectProviders);
    }

    private List<ObjectProvider> lookObjectProviders() {
        ArrayList<ObjectProvider> objectProviders = new ArrayList<ObjectProvider>();
        this.applicationModel.executeOnEveryRootElement(componentModel -> {
            if (componentModel.getType() != null && ObjectProvider.class.isAssignableFrom(componentModel.getType())) {
                objectProviders.add((ObjectProvider)componentModel.getObjectInstance());
            }
        });
        return objectProviders;
    }

    private void registerEditors(ConfigurableListableBeanFactory beanFactory) {
        MulePropertyEditorRegistrar registrar = new MulePropertyEditorRegistrar();
        registrar.setMuleContext(this.muleContext);
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)registrar);
    }

    private void addBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, BeanPostProcessor ... processors) {
        for (BeanPostProcessor processor : processors) {
            beanFactory.addBeanPostProcessor(processor);
        }
    }

    public void close() {
        super.close();
        this.beanDefinitionFactory.destroy();
    }

    private static Resource[] convert(ConfigResource[] resources) {
        Resource[] configResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ConfigResource resource = resources[i];
            if (resource.getUrl() != null) {
                configResources[i] = new UrlResource(resource.getUrl());
                continue;
            }
            try {
                configResources[i] = new ByteArrayResource(IOUtils.toByteArray(resource.getInputStream()), resource.getResourceName());
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configResources;
    }

    protected Resource[] getConfigResources() {
        return (Resource[])ArrayUtils.addAll((Object[])this.artifactConfigResources, (Object[])new Resource[0]);
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        this.createInitialApplicationComponents(beanFactory);
    }

    protected void createInitialApplicationComponents(DefaultListableBeanFactory beanFactory) {
        this.createApplicationComponents(beanFactory, this.applicationModel, true);
    }

    protected List<String> createApplicationComponents(DefaultListableBeanFactory beanFactory, ApplicationModel applicationModel, boolean mustBeRoot) {
        ArrayList<String> createdComponentModels = new ArrayList<String>();
        applicationModel.executeOnEveryMuleComponentTree(componentModel -> {
            if (!mustBeRoot || componentModel.isRoot()) {
                if (componentModel.getIdentifier().equals(ApplicationModel.MULE_IDENTIFIER) || !componentModel.isEnabled()) {
                    return;
                }
                if (componentModel.getNameAttribute() != null) {
                    createdComponentModels.add(componentModel.getNameAttribute());
                }
                this.beanDefinitionFactory.resolveComponentRecursively(componentModel.getParent() != null ? componentModel.getParent() : applicationModel.getRootComponentModel(), (ComponentModel)componentModel, beanFactory, (resolvedComponentModel, registry) -> {
                    if (resolvedComponentModel.isRoot()) {
                        String nameAttribute = resolvedComponentModel.getNameAttribute();
                        if (resolvedComponentModel.getIdentifier().equals(ApplicationModel.CONFIGURATION_IDENTIFIER)) {
                            nameAttribute = "_muleConfiguration";
                        } else if (nameAttribute == null) {
                            nameAttribute = AutoIdUtils.uniqueValue(resolvedComponentModel.getBeanDefinition().getBeanClassName());
                        }
                        registry.registerBeanDefinition(nameAttribute, resolvedComponentModel.getBeanDefinition());
                        MuleArtifactContext.postProcessBeanDefinition(componentModel, registry, nameAttribute);
                    }
                }, null);
            }
        });
        this.registerObjectFromObjectProviders(beanFactory);
        return createdComponentModels;
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        super.customizeBeanFactory(beanFactory);
        new SpringMuleContextServiceConfigurator(this.muleContext, this.applicationModel.getConfigurationProperties(), this.artifactType, this.optionalObjectsController, beanFactory, this.componentLocator, this.serviceDiscoverer).createArtifactServices();
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        Optional<ComponentModel> configurationOptional = this.applicationModel.findComponentDefinitionModel(ApplicationModel.CONFIGURATION_IDENTIFIER);
        if (configurationOptional.isPresent()) {
            return;
        }
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        beanDefinitionRegistry.registerBeanDefinition("_muleConfiguration", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MuleConfigurationConfigurator.class).getBeanDefinition());
    }

    private void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry) {
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalConfigurationAnnotationProcessor", ConfigurationClassPostProcessor.class, null);
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalRequiredAnnotationProcessor", RequiredAnnotationBeanPostProcessor.class, null);
        this.registerInjectorProcessor(registry);
    }

    protected void registerInjectorProcessor(BeanDefinitionRegistry registry) {
        if (this.artifactType.equals((Object)ArtifactType.APP)) {
            this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalAutowiredAnnotationProcessor", MuleInjectorProcessor.class, null);
        } else if (this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ContextExclusiveInjectorProcessor.class);
            builder.addConstructorArgValue((Object)this);
            this.registerPostProcessor(registry, (RootBeanDefinition)builder.getBeanDefinition(), "org.springframework.context.annotation.internalAutowiredAnnotationProcessor");
        }
    }

    private void registerAnnotationConfigProcessor(BeanDefinitionRegistry registry, String key, Class<?> type, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(type);
        beanDefinition.setSource(source);
        this.registerPostProcessor(registry, beanDefinition, key);
    }

    protected void registerPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        ObjectProviderAwareBeanFactory beanFactory = new ObjectProviderAwareBeanFactory(this.getInternalParentBeanFactory());
        beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ContextAnnotationAutowireCandidateResolver());
        beanFactory.setInstantiationStrategy(new LaxInstantiationStrategyWrapper((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(), this.optionalObjectsController));
        return beanFactory;
    }

    public boolean isRunning() {
        try {
            return super.isRunning();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected static void postProcessBeanDefinition(ComponentModel resolvedComponent, BeanDefinitionRegistry registry, String beanName) {
        if (Converter.class.isAssignableFrom(resolvedComponent.getType())) {
            GenericBeanDefinition converterBeanDefinitionCopy = new GenericBeanDefinition(resolvedComponent.getBeanDefinition());
            converterBeanDefinitionCopy.setScope("singleton");
            registry.registerBeanDefinition(beanName + "-converter", (BeanDefinition)converterBeanDefinitionCopy);
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected OptionalObjectsController getOptionalObjectsController() {
        return this.optionalObjectsController;
    }

    public void initializeComponent(Location location) {
        MinimalApplicationModelGenerator minimalApplicationModelGenerator = new MinimalApplicationModelGenerator(this.applicationModel, this.componentBuildingDefinitionRegistry);
        ApplicationModel minimalApplicationModel = minimalApplicationModelGenerator.getMinimalModel(location);
        this.createApplicationComponents((DefaultListableBeanFactory)this.getBeanFactory(), minimalApplicationModel, false);
    }

    public ConnectivityTestingService getConnectivityTestingService() {
        return (ConnectivityTestingService)this.muleContext.getRegistry().lookupObject("_muleConnectivityTestingService");
    }

    public MetadataService getMetadataService() {
        return (MetadataService)this.muleContext.getRegistry().get("_muleMetadataService");
    }
}

