/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.dsl.processor.SimpleConfigAttribute;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlCustomAttributeHandler;
import org.mule.runtime.core.component.config.ConfigurationPropertiesResolver;

public class ComponentModelReader {
    private final ConfigurationPropertiesResolver configurationPropertiesResolver;

    public ComponentModelReader(ConfigurationPropertiesResolver configurationPropertiesResolver) {
        this.configurationPropertiesResolver = configurationPropertiesResolver;
    }

    public ComponentModel extractComponentDefinitionModel(ConfigLine configLine, String configFileName) {
        String namespace = configLine.getNamespace() == null ? "mule" : configLine.getNamespace();
        ComponentModel.Builder builder = new ComponentModel.Builder().setIdentifier(ComponentIdentifier.builder().withNamespace(namespace).withName(configLine.getIdentifier()).build()).setTextContent(this.resolveValueIfIsPlaceHolder(configLine.getTextContent())).setConfigFileName(configFileName).setLineNumber(configLine.getLineNumber());
        XmlCustomAttributeHandler.to(builder).addNode(XmlCustomAttributeHandler.from(configLine).getNode());
        for (SimpleConfigAttribute simpleConfigAttribute : configLine.getConfigAttributes().values()) {
            builder.addParameter(simpleConfigAttribute.getName(), this.resolveValueIfIsPlaceHolder(simpleConfigAttribute.getValue()), simpleConfigAttribute.isValueFromSchema());
        }
        List componentModels = configLine.getChildren().stream().map(childConfigLine -> this.extractComponentDefinitionModel((ConfigLine)childConfigLine, configFileName)).collect(Collectors.toList());
        componentModels.stream().forEach(componentDefinitionModel -> builder.addChildComponentModel((ComponentModel)componentDefinitionModel));
        ConfigLine parent = configLine.getParent();
        if (parent != null && this.isConfigurationTopComponent(parent)) {
            builder.markAsRootComponent();
        }
        ComponentModel componentModel = builder.build();
        for (ComponentModel innerComponentModel : componentModel.getInnerComponents()) {
            innerComponentModel.setParent(componentModel);
        }
        return componentModel;
    }

    private String resolveValueIfIsPlaceHolder(String value) {
        Object resolvedValue = this.configurationPropertiesResolver.resolveValue(value);
        return resolvedValue instanceof String ? (String)resolvedValue : (resolvedValue != null ? resolvedValue.toString() : null);
    }

    private boolean isConfigurationTopComponent(ConfigLine parent) {
        return parent.getIdentifier().equals("mule") || parent.getIdentifier().equals("mule-domain") || parent.getIdentifier().equals("policy");
    }
}

