/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.spring;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.core.api.config.RuntimeConfigurationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class ObjectBeanDefinitionCreator
extends BeanDefinitionCreator {
    private static final String REF_PARAMETER = "ref";
    private static final String CLASS_PARAMETER = "class";

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        ComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        if (!componentModel.getIdentifier().equals(ComponentIdentifier.buildFromStringRepresentation("mule:object"))) {
            return false;
        }
        String refParameterValue = componentModel.getParameters().get(REF_PARAMETER);
        String classParameterValue = componentModel.getParameters().get(CLASS_PARAMETER);
        if (refParameterValue != null && classParameterValue != null) {
            throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Object cannot contain both '%s' and '%s' parameter. Offending resource is '%s'", refParameterValue, classParameterValue, componentModel.getComponentLocation())));
        }
        if (refParameterValue == null && classParameterValue == null) {
            throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Object cannot contain both '%s' and '%s' parameter empty. Offending resource is '%s'", refParameterValue, classParameterValue, componentModel.getComponentLocation())));
        }
        if (refParameterValue != null) {
            componentModel.setBeanReference((BeanReference)new RuntimeBeanReference(refParameterValue));
        }
        if (classParameterValue != null) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)classParameterValue);
            CommonBeanDefinitionCreator.processMuleProperties(componentModel, beanDefinitionBuilder);
            componentModel.setBeanDefinition((BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
        return true;
    }
}

