/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.Collection;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.routing.AbstractSelectiveRouter;
import org.mule.runtime.core.routing.MessageProcessorExpressionPair;
import org.springframework.beans.factory.FactoryBean;

public abstract class AbstractSelectiveRouterFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean<AbstractSelectiveRouter>,
MuleContextAware {
    private Processor defaultProcessor;
    private Collection<MessageProcessorExpressionPair> conditionalMessageProcessors;
    private MuleContext muleContext;

    public void setDefaultRoute(MessageProcessorExpressionPair conditionalProcessor) {
        this.defaultProcessor = conditionalProcessor.getMessageProcessor();
    }

    public void setRoutes(Collection<MessageProcessorExpressionPair> conditionalMessageProcessors) {
        this.conditionalMessageProcessors = conditionalMessageProcessors;
    }

    public AbstractSelectiveRouter getObject() throws Exception {
        AbstractSelectiveRouter router = this.newAbstractSelectiveRouter();
        router.setAnnotations(this.getAnnotations());
        router.setDefaultRoute(this.defaultProcessor);
        router.setMuleContext(this.muleContext);
        for (MessageProcessorExpressionPair mpfp : this.conditionalMessageProcessors) {
            router.addRoute(mpfp.getExpression(), mpfp.getMessageProcessor());
        }
        return router;
    }

    protected abstract AbstractSelectiveRouter newAbstractSelectiveRouter();

    public boolean isSingleton() {
        return true;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

