/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.context.notification.EnrichedServerNotification;
import org.mule.runtime.core.api.context.notification.SynchronousServerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorMessageNotification
extends EnrichedServerNotification
implements SynchronousServerEvent {
    private static final long serialVersionUID = -5118299601117624094L;
    protected static final Logger logger = LoggerFactory.getLogger(ConnectorMessageNotification.class);
    public static final int MESSAGE_RECEIVED = 801;
    public static final int MESSAGE_RESPONSE = 805;
    public static final int MESSAGE_ERROR_RESPONSE = 806;
    public static final int MESSAGE_REQUEST_BEGIN = 804;
    public static final int MESSAGE_REQUEST_END = 853;

    public ConnectorMessageNotification(EnrichedNotificationInfo notificationInfo, FlowConstruct flowConstruct, int action) {
        super(notificationInfo, action, flowConstruct);
        this.flowConstruct = flowConstruct;
    }

    @Override
    public String toString() {
        return this.EVENT_NAME + "{action=" + ConnectorMessageNotification.getActionName(this.action) + ", endpoint: " + this.getLocationUri() + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + ", serverId=" + this.serverId + ", message: " + this.source + "}";
    }

    @Override
    public String getType() {
        return "trace";
    }

    static {
        ConnectorMessageNotification.registerAction("receive", 801);
        ConnectorMessageNotification.registerAction("response", 805);
        ConnectorMessageNotification.registerAction("error response", 806);
        ConnectorMessageNotification.registerAction("begin request", 804);
        ConnectorMessageNotification.registerAction("end request", 853);
    }
}

