/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.processor.Processor;

public class EnrichedNotificationInfo {
    private String id;
    private String correlationId;
    private GroupCorrelation groupCorrelation;
    private Message message;
    private Optional<Error> error;
    private Object component;
    private Exception exception;
    private Map<String, TypedValue> variables;
    private String originatingFlowName;
    private FlowCallStack flowCallStack;
    Event event;

    public static EnrichedNotificationInfo createInfo(Event event, Exception e, Object component) {
        if (event != null) {
            if (component == null && e != null) {
                component = EnrichedNotificationInfo.componentFromException(e);
            }
            EnrichedNotificationInfo notificationInfo = new EnrichedNotificationInfo(event.getContext().getId(), event.getCorrelationId(), event.getGroupCorrelation(), event.getMessage(), event.getError(), component, e, EnrichedNotificationInfo.createVariablesMap(event), event.getContext().getOriginatingFlowName(), event.getFlowCallStack());
            notificationInfo.event = event;
            return notificationInfo;
        }
        if (e != null) {
            if (e instanceof MessagingException) {
                MessagingException messagingException = (MessagingException)e;
                if (messagingException.getEvent() != null) {
                    return EnrichedNotificationInfo.createInfo(messagingException.getEvent(), e, EnrichedNotificationInfo.componentFromException(e));
                }
            } else {
                EnrichedNotificationInfo notificationInfo = new EnrichedNotificationInfo(null, null, null, null, null, null, e, new HashMap<String, TypedValue>(), null, null);
                notificationInfo.event = event;
                return notificationInfo;
            }
        }
        throw new RuntimeException("Neither event or exception present");
    }

    private static Map<String, TypedValue> createVariablesMap(Event event) {
        HashMap<String, TypedValue> variables = new HashMap<String, TypedValue>();
        event.getVariableNames().forEach(name -> variables.put((String)name, event.getVariable((String)name)));
        return variables;
    }

    private static AnnotatedObject componentFromException(Exception e) {
        MessagingException messagingException;
        Processor messageProcessor;
        if (e instanceof MessagingException && (messageProcessor = (messagingException = (MessagingException)e).getFailingMessageProcessor()) instanceof AnnotatedObject) {
            return (AnnotatedObject)((Object)messageProcessor);
        }
        return null;
    }

    public EnrichedNotificationInfo(String uniqueId, String correlationId, GroupCorrelation groupCorrelation, Message message, Optional<Error> error, Object component, Exception exception, Map<String, TypedValue> variables, String originatingFlowName, FlowCallStack flowCallStack) {
        this.id = uniqueId;
        this.correlationId = correlationId;
        this.groupCorrelation = groupCorrelation;
        this.message = message;
        this.error = error;
        this.component = component;
        this.exception = exception;
        this.variables = variables;
        this.originatingFlowName = originatingFlowName;
        this.flowCallStack = flowCallStack;
    }

    public String getUniqueId() {
        return this.id;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public GroupCorrelation getGroupCorrelation() {
        return this.groupCorrelation;
    }

    public Message getMessage() {
        return this.message;
    }

    public Optional<Error> getError() {
        return this.error;
    }

    public Map<String, TypedValue> getVariables() {
        return this.variables;
    }

    public AnnotatedObject getComponent() {
        if (this.component != null && this.component instanceof AnnotatedObject) {
            return (AnnotatedObject)this.component;
        }
        return null;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getOriginatingFlowName() {
        return this.originatingFlowName;
    }

    public FlowCallStack getFlowCallStack() {
        return this.flowCallStack;
    }

    public TypedValue evaluateExpression(ExpressionManager expressionManager, String script) {
        return expressionManager.evaluate(script, this.event);
    }
}

