/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;

public class ListenerSubscriptionPair
extends AbstractAnnotatedObject {
    private final ServerNotificationListener listener;
    private final Optional<String> subscription;

    public ListenerSubscriptionPair() {
        this.listener = null;
        this.subscription = Optional.empty();
    }

    public ListenerSubscriptionPair(ServerNotificationListener listener) {
        this.listener = listener;
        this.subscription = Optional.empty();
    }

    public ListenerSubscriptionPair(ServerNotificationListener listener, String subscription) {
        this.listener = listener;
        this.subscription = Optional.ofNullable(subscription);
    }

    public ServerNotificationListener getListener() {
        return this.listener;
    }

    public Optional<String> getSubscription() {
        return this.subscription;
    }

    public int hashCode() {
        return Objects.hash(this.listener, this.subscription);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListenerSubscriptionPair other = (ListenerSubscriptionPair)obj;
        return Objects.equals(this.listener, other.listener) && Objects.equals(this.subscription, other.subscription);
    }

    public String toString() {
        return "ListenerSubscriptionPair [listener=" + this.listener + ", subscription=" + this.subscription + "]";
    }
}

