/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.processor.chain.ExplicitMessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class MessageProcessors {
    private MessageProcessors() {
    }

    public static MessageProcessorChain newChain(Processor ... processors) {
        if (processors.length == 1 && processors[0] instanceof MessageProcessorChain && !(processors[0] instanceof ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain)) {
            return (MessageProcessorChain)processors[0];
        }
        return new DefaultMessageProcessorChainBuilder().chain(processors).build();
    }

    public static MessageProcessorChain newChain(List<Processor> processors) {
        if (processors.size() == 1 && processors.get(0) instanceof MessageProcessorChain && !(processors.get(0) instanceof ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain)) {
            return (MessageProcessorChain)processors.get(0);
        }
        return new DefaultMessageProcessorChainBuilder().chain(processors).build();
    }

    public static MessageProcessorChain newExplicitChain(Processor ... processors) {
        if (processors.length == 1 && processors[0] instanceof ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain) {
            return (MessageProcessorChain)processors[0];
        }
        return new ExplicitMessageProcessorChainBuilder().chain(processors).build();
    }

    public static MessageProcessorChain newExplicitChain(List<Processor> processors) {
        if (processors.size() == 1 && processors.get(0) instanceof ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain) {
            return (MessageProcessorChain)processors.get(0);
        }
        return new ExplicitMessageProcessorChainBuilder().chain(processors).build();
    }

    public static Event processToApply(Event event, ReactiveProcessor processor) throws MuleException {
        try {
            return (Event)Mono.just((Object)event).transform((Function)processor).switchIfEmpty(Mono.from(event.getContext().getResponsePublisher())).block();
        }
        catch (Throwable e) {
            throw Exceptions.rxExceptionToMuleException(e);
        }
    }

    public static Publisher<Event> processWithChildContext(Event event, ReactiveProcessor processor) {
        EventContext child = DefaultEventContext.child(event.getContext());
        Mono.just((Object)Event.builder(child, event).build()).transform((Function)processor).subscribe(response -> {
            if (!Mono.from(child.getResponsePublisher()).toFuture().isDone()) {
                child.success((Event)response);
            }
        }, child::error);
        return Mono.from(child.getResponsePublisher()).map(result -> Event.builder(event.getContext(), result).build()).doOnError(MessagingException.class, me -> me.setProcessedEvent(Event.builder(event.getContext(), me.getEvent()).build()));
    }
}

