/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.store.ListableObjectStore;

public abstract class ObjectStoreToMapAdapter<T extends Serializable>
implements Map<Serializable, T> {
    protected abstract ListableObjectStore<T> getObjectStore();

    @Override
    public int size() {
        try {
            return this.getObjectStore().allKeys().size();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.getObjectStore().allKeys().isEmpty();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.getObjectStore().contains((Serializable)key);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Map adapter for object store does not support contains value");
    }

    @Override
    public T get(Object key) {
        try {
            if (!this.getObjectStore().contains((Serializable)key)) {
                return null;
            }
            return this.getObjectStore().retrieve((Serializable)key);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public T put(Serializable key, T value) {
        T previousValue = null;
        try {
            if (this.getObjectStore().contains(key)) {
                previousValue = this.getObjectStore().retrieve(key);
                this.getObjectStore().remove(key);
            }
            if (value != null) {
                this.getObjectStore().store(key, value);
            }
            return previousValue;
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public T remove(Object key) {
        try {
            if (this.getObjectStore().contains((Serializable)key)) {
                return this.getObjectStore().remove((Serializable)key);
            }
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Serializable, ? extends T> mapToAdd) {
        for (Serializable serializable : mapToAdd.keySet()) {
            this.put(serializable, (T)((Serializable)mapToAdd.get(serializable)));
        }
    }

    @Override
    public void clear() {
        try {
            this.getObjectStore().clear();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public Set<Serializable> keySet() {
        try {
            List<Serializable> allKeys = this.getObjectStore().allKeys();
            return new HashSet<Serializable>(allKeys);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public Collection<T> values() {
        throw new UnsupportedOperationException("ObjectStoreToMapAdapter does not support values() method");
    }

    @Override
    public Set<Map.Entry<Serializable, T>> entrySet() {
        throw new UnsupportedOperationException("ObjectStoreToMapAdapter does not support entrySet() method");
    }
}

