/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.Component;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.ComponentMessageNotification;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAware;
import org.mule.runtime.core.api.interceptor.Interceptor;
import org.mule.runtime.core.api.management.stats.ComponentStatistics;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.component.ComponentException;
import org.mule.runtime.core.component.ComponentLifecycleManager;
import org.mule.runtime.core.internal.VoidResult;
import org.mule.runtime.core.internal.context.notification.OptimisedNotificationHandler;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.transformer.TransformerTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponent
extends AbstractAnnotatedObject
implements Component,
MuleContextAware,
Lifecycle,
MessagingExceptionHandlerAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected FlowConstruct flowConstruct;
    protected ComponentStatistics statistics = null;
    protected ServerNotificationHandler notificationHandler;
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    protected MessageProcessorChain interceptorChain;
    protected MuleContext muleContext;
    protected ComponentLifecycleManager lifecycleManager;
    private MessagingExceptionHandler messagingExceptionHandler;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public AbstractComponent() {
        this.statistics = new ComponentStatistics();
        this.lifecycleManager = new ComponentLifecycleManager(this.getName(), this);
    }

    private Event invokeInternal(Event event) throws MuleException {
        Event.setCurrentEvent(event);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Invoking %s component for service %s", this.getClass().getName(), this.flowConstruct.getName()));
        }
        if (!this.lifecycleManager.getState().isStarted() || this.lifecycleManager.getState().isStopping()) {
            throw new LifecycleException(CoreMessages.isStopped(this.flowConstruct.getName()), (Object)this);
        }
        try {
            this.fireComponentNotification(event, 1401);
            long startTime = 0L;
            if (this.statistics.isEnabled()) {
                startTime = System.currentTimeMillis();
            }
            Event.Builder resultEventBuilder = Event.builder(event);
            Object result = this.doInvoke(event, resultEventBuilder);
            if (this.statistics.isEnabled()) {
                this.statistics.addExecutionTime(System.currentTimeMillis() - startTime);
            }
            Event resultEvent = this.createResultEvent(event, resultEventBuilder, result);
            this.fireComponentNotification(resultEvent, 1402);
            return resultEvent;
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ComponentException(CoreMessages.failedToInvoke(this.toString()), this, e);
        }
    }

    @Override
    public Event process(Event event) throws MuleException {
        return StreamingUtils.withCursoredEvent(event, cursoredEvent -> {
            if (this.interceptorChain == null) {
                return this.invokeInternal((Event)cursoredEvent);
            }
            return this.interceptorChain.process((Event)cursoredEvent);
        });
    }

    protected Event createResultEvent(Event event, Event.Builder resultEventBuilder, Object result) throws MuleException {
        if (result instanceof Message) {
            return resultEventBuilder.message((Message)result).build();
        }
        if (result instanceof VoidResult) {
            return event;
        }
        TransformerTemplate template = new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result));
        template.setReturnDataType(DataType.builder(DataType.OBJECT).charset(SystemUtils.getDefaultEncoding(this.muleContext)).build());
        return resultEventBuilder.message(this.muleContext.getTransformationService().applyTransformers(event.getMessage(), event, Collections.singletonList(template))).build();
    }

    protected abstract Object doInvoke(Event var1, Event.Builder var2) throws Exception;

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }

    public void release() {
    }

    @Override
    public ComponentStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public final void initialise() throws InitialisationException {
        if (this.flowConstruct == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Component has not been initialized properly, no flow constuct."), (Initialisable)this);
        }
        this.lifecycleManager.fireInitialisePhase((phaseName, object) -> {
            DefaultMessageProcessorChainBuilder chainBuilder = new DefaultMessageProcessorChainBuilder();
            chainBuilder.setName("Component interceptor processor chain for :" + this.getName());
            for (Interceptor interceptor : this.interceptors) {
                chainBuilder.chain(interceptor);
            }
            chainBuilder.chain(new AnnotatedProcessor(event -> this.invokeInternal(event)));
            this.interceptorChain = chainBuilder.build();
            this.applyLifecycleAndDependencyInjection(this.interceptorChain);
            this.doInitialise();
        });
    }

    protected void applyLifecycleAndDependencyInjection(Object object) throws InitialisationException {
        if (object instanceof MuleContextAware) {
            ((MuleContextAware)object).setMuleContext(this.muleContext);
        }
        if (object instanceof FlowConstructAware) {
            ((FlowConstructAware)object).setFlowConstruct(this.flowConstruct);
        }
        if (object instanceof MessagingExceptionHandlerAware) {
            ((MessagingExceptionHandlerAware)object).setMessagingExceptionHandler(this.messagingExceptionHandler);
        }
        if (object instanceof Initialisable) {
            ((Initialisable)object).initialise();
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    @Override
    public void dispose() {
        this.lifecycleManager.fireDisposePhase((phaseName, object) -> this.doDispose());
    }

    protected void doDispose() {
    }

    @Override
    public void stop() throws MuleException {
        try {
            this.lifecycleManager.fireStopPhase((phaseName, object) -> this.doStop());
        }
        catch (MuleException e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void doStart() throws MuleException {
    }

    @Override
    public void start() throws MuleException {
        this.lifecycleManager.fireStartPhase((phaseName, object) -> {
            this.notificationHandler = new OptimisedNotificationHandler(this.muleContext.getNotificationManager(), ComponentMessageNotification.class);
            this.doStart();
        });
    }

    protected void doStop() throws MuleException {
    }

    protected void fireComponentNotification(Event event, int action) {
        if (this.notificationHandler != null && this.notificationHandler.isNotificationEnabled(ComponentMessageNotification.class)) {
            this.notificationHandler.fireNotification(new ComponentMessageNotification(EnrichedNotificationInfo.createInfo(event, null, this), this.flowConstruct, action));
        }
    }

    protected String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.flowConstruct != null) {
            sb.append(this.flowConstruct.getName());
            sb.append(".");
        }
        sb.append("component");
        sb.append(".");
        sb.append(System.identityHashCode(this));
        return sb.toString();
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        this.messagingExceptionHandler = messagingExceptionHandler;
    }

    public static class AnnotatedProcessor
    extends AbstractAnnotatedObject
    implements Processor {
        private Processor processor;

        public AnnotatedProcessor(Processor processor) {
            this.processor = processor;
        }

        @Override
        public Event process(Event event) throws MuleException {
            return this.processor.process(event);
        }
    }
}

