/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.core.api.component.Component;
import org.mule.runtime.core.api.config.i18n.CoreMessages;

public class ComponentException
extends MuleException {
    private static final long serialVersionUID = 56178344205041600L;
    private final transient Component component;

    public ComponentException(I18nMessage message, Component component) {
        super(ComponentException.generateMessage(message, component));
        this.component = component;
    }

    public ComponentException(I18nMessage message, Component component, Throwable cause) {
        super(ComponentException.generateMessage(message, component), cause);
        this.component = component;
    }

    public ComponentException(Component component, Throwable cause) {
        super(ComponentException.generateMessage(null, component), cause);
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    protected void setMessage(I18nMessage message) {
        super.setMessage(message.getMessage());
    }

    private static I18nMessage generateMessage(I18nMessage previousMessage, Component component) {
        I18nMessage returnMessage = CoreMessages.componentCausedErrorIs(component);
        if (previousMessage != null) {
            previousMessage.setNextMessage(returnMessage);
            return previousMessage;
        }
        return returnMessage;
    }
}

