/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.core.api.Event;

public class BindingContextUtils {
    public static final String PAYLOAD = "payload";
    public static final String DATA_TYPE = "dataType";
    public static final String ATTRIBUTES = "attributes";
    public static final String ERROR = "error";
    public static final String CORRELATION_ID = "correlationId";
    public static final String VARIABLES = "variables";
    public static final String PROPERTIES = "properties";
    public static final String PARAMETERS = "parameters";
    public static final String AUTHENTICATION = "authentication";
    public static final String FLOW = "flow";
    public static final String SERVER = "server";
    public static final String MULE = "mule";
    public static final String APP = "app";
    public static final BindingContext NULL_BINDING_CONTEXT = BindingContext.builder().build();

    private BindingContextUtils() {
    }

    public static BindingContext addEventBindings(Event event, BindingContext baseContext) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(baseContext);
        BindingContext.Builder contextBuilder = BindingContext.builder(baseContext);
        HashMap flowVars = new HashMap();
        event.getVariableNames().forEach(name -> {
            TypedValue value = event.getVariable((String)name);
            flowVars.put(name, value);
            contextBuilder.addBinding((String)name, value);
        });
        contextBuilder.addBinding(VARIABLES, new TypedValue(Collections.unmodifiableMap(flowVars), DataType.fromType(flowVars.getClass())));
        contextBuilder.addBinding(PROPERTIES, new TypedValue<Map<String, TypedValue<Object>>>(Collections.unmodifiableMap(event.getProperties()), DataType.fromType(event.getProperties().getClass())));
        contextBuilder.addBinding(PARAMETERS, new TypedValue<Map<String, TypedValue<Object>>>(Collections.unmodifiableMap(event.getParameters()), DataType.fromType(event.getParameters().getClass())));
        contextBuilder.addBinding(CORRELATION_ID, new TypedValue<String>(event.getContext().getCorrelationId(), DataType.STRING));
        Message message = event.getMessage();
        contextBuilder.addBinding(ATTRIBUTES, message.getAttributes());
        contextBuilder.addBinding(PAYLOAD, message.getPayload());
        contextBuilder.addBinding(DATA_TYPE, new TypedValue<DataType>(message.getPayload().getDataType(), DataType.fromType(DataType.class)));
        Error error = event.getError().isPresent() ? event.getError().get() : null;
        contextBuilder.addBinding(ERROR, new TypedValue<Error>(error, DataType.fromType(Error.class)));
        Authentication authentication = event.getSecurityContext() != null ? event.getSecurityContext().getAuthentication() : null;
        contextBuilder.addBinding(AUTHENTICATION, new TypedValue<Authentication>(authentication, DataType.fromType(Authentication.class)));
        return contextBuilder.build();
    }
}

