/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.Iterator;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.el.BindingContextUtils;
import org.mule.runtime.core.el.context.AppContext;
import org.mule.runtime.core.el.context.MuleInstanceContext;
import org.mule.runtime.core.el.context.ServerContext;

public class DataWeaveExpressionLanguageAdaptor
implements ExtendedExpressionLanguageAdaptor {
    public static final String PAYLOAD = "payload";
    public static final String DATA_TYPE = "dataType";
    public static final String ATTRIBUTES = "attributes";
    public static final String ERROR = "error";
    public static final String ID = "id";
    public static final String CORRELATION_ID = "correlationId";
    public static final String VARIABLES = "variables";
    public static final String PROPERTIES = "properties";
    public static final String PARAMETERS = "parameters";
    public static final String FLOW = "flow";
    public static final String SERVER = "server";
    public static final String MULE = "mule";
    public static final String APP = "app";
    private ExpressionLanguage expressionExecutor;
    private MuleContext muleContext;

    public static DataWeaveExpressionLanguageAdaptor create(MuleContext muleContext) {
        try {
            return new DataWeaveExpressionLanguageAdaptor(muleContext, muleContext.getRegistry().lookupObject(DefaultExpressionLanguageFactoryService.class));
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Unable to obtain expression executor."), (Throwable)e);
        }
    }

    @Inject
    public DataWeaveExpressionLanguageAdaptor(MuleContext muleContext, DefaultExpressionLanguageFactoryService service) {
        this.expressionExecutor = service.create();
        this.muleContext = muleContext;
        this.registerGlobalBindings();
    }

    private void registerGlobalBindings() {
        BindingContext.Builder contextBuilder = BindingContext.builder();
        contextBuilder.addBinding(MULE, new TypedValue<MuleInstanceContext>(new MuleInstanceContext(this.muleContext), DataType.fromType(MuleInstanceContext.class)));
        contextBuilder.addBinding(SERVER, new TypedValue<ServerContext>(new ServerContext(), DataType.fromType(ServerContext.class)));
        contextBuilder.addBinding(APP, new TypedValue<AppContext>(new AppContext(this.muleContext), DataType.fromType(AppContext.class)));
        this.addGlobalBindings(contextBuilder.build());
    }

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
        this.expressionExecutor.addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, BindingContext context) {
        String sanitized = this.sanitize(expression);
        if (this.isPayloadExpression(sanitized)) {
            return event.getMessage().getPayload();
        }
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, context);
        return this.evaluate(sanitized, exp -> this.expressionExecutor.evaluate((String)exp, contextBuilder.build()));
    }

    private boolean isPayloadExpression(String sanitized) {
        return sanitized.equals(PAYLOAD);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, Event event, BindingContext context) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, context);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.evaluate((String)exp, expectedOutputType, contextBuilder.build()));
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, Event event, FlowConstruct flowConstruct, BindingContext context, boolean failOnNull) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, context);
        this.addFlowBindings(flowConstruct, contextBuilder);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.evaluate((String)exp, expectedOutputType, contextBuilder.build()));
    }

    @Override
    public TypedValue evaluate(String expression, Event event, FlowConstruct flowConstruct, BindingContext bindingContext) {
        return this.evaluate(expression, event, null, flowConstruct, bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, BindingContext context) {
        String sanitized = this.sanitize(expression);
        if (this.isPayloadExpression(sanitized)) {
            return event.getMessage().getPayload();
        }
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, context);
        this.addFlowBindings(flowConstruct, contextBuilder);
        return this.evaluate(sanitized, exp -> this.expressionExecutor.evaluate((String)exp, contextBuilder.build()));
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.expressionExecutor.validate(this.sanitize(expression));
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, Event event, FlowConstruct flowConstruct, BindingContext bindingContext) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, bindingContext);
        this.addFlowBindings(flowConstruct, contextBuilder);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.split((String)exp, contextBuilder.build()));
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, Event event, BindingContext bindingContext) throws ExpressionRuntimeException {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, bindingContext);
        return this.sanitizeAndEvaluate(expression, exp -> this.expressionExecutor.split((String)exp, contextBuilder.build()));
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, Object object) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, TypedValue value) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    private <T> T sanitizeAndEvaluate(String expression, Function<String, T> evaluation) {
        return this.evaluate(this.sanitize(expression), evaluation);
    }

    private <T> T evaluate(String expression, Function<String, T> evaluation) {
        try {
            return evaluation.apply(expression);
        }
        catch (ExpressionExecutionException e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), (Throwable)e);
        }
    }

    private BindingContext.Builder addFlowBindings(FlowConstruct flow, BindingContext.Builder contextBuilder) {
        if (flow != null) {
            contextBuilder.addBinding(FLOW, new TypedValue<FlowVariablesAccessor>(new FlowVariablesAccessor(flow.getName()), DataType.fromType(FlowVariablesAccessor.class)));
        }
        return contextBuilder;
    }

    private BindingContext.Builder bindingContextBuilderFor(Event event, BindingContext context) {
        if (event != null) {
            return BindingContext.builder(BindingContextUtils.addEventBindings(event, context));
        }
        return BindingContext.builder(context);
    }

    private String sanitize(String expression) {
        String sanitizedExpression;
        String string = sanitizedExpression = expression.startsWith("#[") ? expression.substring("#[".length(), expression.length() - "]".length()) : expression;
        if (sanitizedExpression.startsWith("dw:")) {
            sanitizedExpression = sanitizedExpression.substring("dw:".length());
        }
        return sanitizedExpression;
    }

    private class FlowVariablesAccessor {
        private String name;

        public FlowVariablesAccessor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

