/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.el.DataWeaveExpressionLanguageAdaptor;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;

public class ExpressionLanguageAdaptorHandler
implements ExtendedExpressionLanguageAdaptor {
    private static final String EXPR_PREFIX_LANGS_TOKEN = "LANGS";
    private static final String EXPR_PREFIX_PATTERN_TEMPLATE = "^\\s*(?:(?:#\\[)?\\s*(LANGS):|\\%(LANGS) \\d).*";
    private final Pattern exprPrefixPattern;
    private Map<String, ExtendedExpressionLanguageAdaptor> expressionLanguages = new HashMap<String, ExtendedExpressionLanguageAdaptor>();
    private boolean melDefault = false;

    public ExpressionLanguageAdaptorHandler(DataWeaveExpressionLanguageAdaptor defaultExtendedExpressionLanguage, MVELExpressionLanguage mvelExpressionLanguage) {
        this.expressionLanguages.put("dw", defaultExtendedExpressionLanguage);
        this.expressionLanguages.put("mel", mvelExpressionLanguage);
        this.exprPrefixPattern = Pattern.compile(EXPR_PREFIX_PATTERN_TEMPLATE.replaceAll(EXPR_PREFIX_LANGS_TOKEN, StringUtils.join(this.expressionLanguages.keySet(), (char)'|')));
        this.melDefault = Boolean.valueOf(System.getProperty("mule.test.mel.default", "false"));
    }

    public boolean isMelDefault() {
        return this.melDefault;
    }

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
        this.expressionLanguages.get("dw").addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, BindingContext context) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, context);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, Event event, BindingContext context) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, expectedOutputType, event, context);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, Event event, FlowConstruct flowConstruct, BindingContext context, boolean failOnNull) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, expectedOutputType, event, flowConstruct, context, failOnNull);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, FlowConstruct flowConstruct, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, flowConstruct, bindingContext);
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.selectExpressionLanguage(expression).validate(expression);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, eventBuilder, flowConstruct, bindingContext);
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, Object object) {
        this.selectExpressionLanguage(expression).enrich(expression, event, eventBuilder, flowConstruct, object);
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, TypedValue value) {
        this.selectExpressionLanguage(expression).enrich(expression, event, eventBuilder, flowConstruct, value);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, Event event, FlowConstruct flowConstruct, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).split(expression, event, flowConstruct, bindingContext);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, Event event, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).split(expression, event, bindingContext);
    }

    private ExtendedExpressionLanguageAdaptor selectExpressionLanguage(String expression) {
        String languagePrefix = this.getLanguagePrefix(expression);
        if (StringUtils.isEmpty((CharSequence)languagePrefix)) {
            if (this.melDefault) {
                return this.expressionLanguages.get("mel");
            }
            return this.expressionLanguages.get("dw");
        }
        return this.expressionLanguages.get(languagePrefix);
    }

    private String getLanguagePrefix(String expression) {
        Matcher matcher = this.exprPrefixPattern.matcher(expression);
        if (matcher.find()) {
            int i = 1;
            String currentGroup = null;
            while (currentGroup == null) {
                currentGroup = matcher.group(i++);
            }
            return currentGroup;
        }
        return null;
    }
}

