/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;

public class ReconnectableConnectionProviderWrapper<C>
extends ConnectionProviderWrapper<C> {
    private final boolean disableValidation;
    private final RetryPolicyTemplate retryPolicyTemplate;

    public ReconnectableConnectionProviderWrapper(ConnectionProvider<C> delegate, boolean disableValidation, RetryPolicyTemplate retryPolicyTemplate) {
        super(delegate);
        this.disableValidation = disableValidation;
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        if (this.disableValidation) {
            return ConnectionValidationResult.success();
        }
        return this.getDelegate().validate(connection);
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }
}

