/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.enricher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.session.DefaultMuleSession;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.processor.AbstractMessageProcessorOwner;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class MessageEnricher
extends AbstractMessageProcessorOwner
implements Processor {
    private List<EnrichExpressionPair> enrichExpressionPairs = new ArrayList<EnrichExpressionPair>();
    private Processor enrichmentProcessor;

    @Override
    public Event process(Event event) throws MuleException {
        return this.enrich(this.enrichmentProcessor.process(Event.builder(event).session(new DefaultMuleSession(event.getSession())).build()), event);
    }

    protected Event enrich(Event currentEvent, Event enrichmentEvent, String sourceExpressionArg, String targetExpressionArg, ExtendedExpressionManager expressionManager) {
        TypedValue typedValue;
        if (StringUtils.isEmpty(sourceExpressionArg)) {
            sourceExpressionArg = "#[mel:payload:]";
        }
        if ((typedValue = expressionManager.evaluate(sourceExpressionArg, enrichmentEvent, this.flowConstruct)).getValue() instanceof Message) {
            Message muleMessage = (Message)typedValue.getValue();
            typedValue = new TypedValue(muleMessage.getPayload().getValue(), muleMessage.getPayload().getDataType());
        }
        if (!StringUtils.isEmpty(targetExpressionArg)) {
            Event.Builder eventBuilder = Event.builder(currentEvent);
            expressionManager.enrich(targetExpressionArg, currentEvent, eventBuilder, this.flowConstruct, typedValue);
            return eventBuilder.build();
        }
        return Event.builder(currentEvent).message(Message.builder(currentEvent.getMessage()).payload(typedValue.getValue()).mediaType(typedValue.getDataType().getMediaType()).build()).build();
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Flux.from(publisher).flatMap(event -> Flux.from(MessageProcessors.processWithChildContext(Event.builder(event).session(new DefaultMuleSession(event.getSession())).build(), this.enrichmentProcessor)).map(Exceptions.checkedFunction(response -> this.enrich((Event)response, (Event)event))).defaultIfEmpty(event));
    }

    protected Event enrich(Event event, Event eventToEnrich) throws MuleException {
        ExtendedExpressionManager expressionManager = this.muleContext.getExpressionManager();
        if (event != null) {
            for (EnrichExpressionPair pair : this.enrichExpressionPairs) {
                eventToEnrich = this.enrich(eventToEnrich, event, pair.getSource(), pair.getTarget(), expressionManager);
            }
        }
        Event.setCurrentEvent(eventToEnrich);
        return eventToEnrich;
    }

    public void setEnrichmentMessageProcessor(Processor enrichmentProcessor) {
        this.enrichmentProcessor = MessageProcessors.newChain(enrichmentProcessor);
        LifecycleUtils.setMuleContextIfNeeded(this.enrichmentProcessor, this.muleContext);
    }

    public void setMessageProcessor(Processor enrichmentProcessor) {
        this.setEnrichmentMessageProcessor(enrichmentProcessor);
    }

    public void setEnrichExpressionPairs(List<EnrichExpressionPair> enrichExpressionPairs) {
        this.enrichExpressionPairs = enrichExpressionPairs;
    }

    public void addEnrichExpressionPair(EnrichExpressionPair pair) {
        this.enrichExpressionPairs.add(pair);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.enrichmentProcessor);
    }

    public static class EnrichExpressionPair
    extends AbstractAnnotatedObject {
        private String source;
        private String target;

        public EnrichExpressionPair() {
        }

        public EnrichExpressionPair(String target) {
            this.target = target;
        }

        public EnrichExpressionPair(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }
    }
}

