/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.GlobalNameableObject;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.exception.MessagingExceptionStrategyAcceptorDelegate;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.processor.AbstractMuleObjectOwner;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ErrorHandler
extends AbstractMuleObjectOwner<MessagingExceptionHandlerAcceptor>
implements MessagingExceptionHandlerAcceptor,
MuleContextAware,
Lifecycle,
GlobalNameableObject {
    private static final String MUST_ACCEPT_ANY_EVENT_MESSAGE = "Default exception strategy must accept any event.";
    private List<MessagingExceptionHandlerAcceptor> exceptionListeners;
    private ErrorTypeMatcher criticalMatcher = new SingleErrorTypeMatcher(ErrorTypeRepository.CRITICAL_ERROR_TYPE);
    protected String globalName;

    @Override
    public String getGlobalName() {
        return this.globalName;
    }

    @Override
    public void setGlobalName(String globalName) {
        this.globalName = globalName;
    }

    @Override
    public Event handleException(MessagingException exception, Event event) {
        event = this.addExceptionPayload(exception, event);
        if (this.isCriticalException(exception)) {
            return event;
        }
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!exceptionListener.accept(event)) continue;
            return exceptionListener.handleException(exception, event);
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(MUST_ACCEPT_ANY_EVENT_MESSAGE));
    }

    @Override
    public Publisher<Event> apply(MessagingException exception) {
        if (this.isCriticalException(exception)) {
            return Mono.error((Throwable)exception);
        }
        Event event = this.addExceptionPayload(exception, exception.getEvent());
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!exceptionListener.accept(event)) continue;
            return exceptionListener.apply(new MessagingException(event, exception));
        }
        return Mono.error((Throwable)new MuleRuntimeException(I18nMessageFactory.createStaticMessage(MUST_ACCEPT_ANY_EVENT_MESSAGE)));
    }

    private Event addExceptionPayload(MessagingException exception, Event event) {
        return Event.builder(event).message(InternalMessage.builder(event.getMessage()).exceptionPayload(new DefaultExceptionPayload(exception)).build()).build();
    }

    private boolean isCriticalException(MessagingException exception) {
        Optional<Error> error = exception.getEvent().getError();
        return error.isPresent() && this.criticalMatcher.match(error.get().getErrorType());
    }

    public void setExceptionListeners(List<MessagingExceptionHandlerAcceptor> exceptionListeners) {
        this.exceptionListeners = exceptionListeners;
    }

    public List<MessagingExceptionHandlerAcceptor> getExceptionListeners() {
        return Collections.unmodifiableList(this.exceptionListeners);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.addDefaultExceptionStrategyIfRequired();
        this.validateConfiguredExceptionStrategies();
    }

    private void addDefaultExceptionStrategyIfRequired() throws InitialisationException {
        if (!this.exceptionListeners.get(this.exceptionListeners.size() - 1).acceptsAll()) {
            MessagingExceptionHandler defaultExceptionStrategy;
            String defaultErrorHandlerName = this.getMuleContext().getConfiguration().getDefaultErrorHandlerName();
            if (defaultErrorHandlerName != null && defaultErrorHandlerName.equals(this.getGlobalName())) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage("Default error-handler must include a final component that matches all errors."), (Initialisable)this);
            }
            try {
                defaultExceptionStrategy = this.getMuleContext().getDefaultErrorHandler();
            }
            catch (Exception e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage("Failure initializing error-handler. If error-handler is defined as default one check that last exception strategy inside matches all errors"), (Throwable)e, this);
            }
            MessagingExceptionStrategyAcceptorDelegate acceptsAllStrategy = new MessagingExceptionStrategyAcceptorDelegate(defaultExceptionStrategy);
            LifecycleUtils.initialiseIfNeeded((Object)acceptsAllStrategy, this.muleContext, this.flowConstruct);
            this.exceptionListeners.add(acceptsAllStrategy);
        }
    }

    @Override
    protected List<MessagingExceptionHandlerAcceptor> getOwnedObjects() {
        return this.exceptionListeners != null ? Collections.unmodifiableList(this.exceptionListeners) : Collections.emptyList();
    }

    private void validateConfiguredExceptionStrategies() {
        this.validateOnlyLastAcceptsAll();
    }

    private void validateOnlyLastAcceptsAll() {
        for (int i = 0; i < this.exceptionListeners.size() - 1; ++i) {
            MessagingExceptionHandlerAcceptor messagingExceptionHandlerAcceptor = this.exceptionListeners.get(i);
            if (!messagingExceptionHandlerAcceptor.acceptsAll()) continue;
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Only last exception strategy inside <error-handler> can accept any message. Maybe expression attribute is empty."));
        }
    }

    @Override
    public boolean accept(Event event) {
        return true;
    }

    @Override
    public boolean acceptsAll() {
        return true;
    }
}

