/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.execution.MessageProcessContext;
import org.mule.runtime.core.api.execution.MessageProcessTemplate;
import org.mule.runtime.core.api.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.runtime.core.api.scheduler.SchedulerBusyException;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.internal.execution.AsyncResponseFlowProcessingPhaseTemplate;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.mule.runtime.core.internal.execution.NotificationFiringProcessingPhase;
import org.mule.runtime.core.internal.execution.PhaseResultNotifier;
import org.mule.runtime.core.internal.execution.ResponseCompletionCallback;
import org.mule.runtime.core.internal.execution.ValidationPhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResponseFlowProcessingPhase
extends NotificationFiringProcessingPhase<AsyncResponseFlowProcessingPhaseTemplate> {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
        return messageProcessTemplate instanceof AsyncResponseFlowProcessingPhaseTemplate;
    }

    @Override
    public void runPhase(AsyncResponseFlowProcessingPhaseTemplate template, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier) {
        Runnable flowExecutionWork = () -> {
            try {
                MessageSource messageSource = messageProcessContext.getMessageSource();
                try {
                    MessagingExceptionHandler exceptionHandler = messageProcessContext.getFlowConstruct().getExceptionListener();
                    TransactionalErrorHandlingExecutionTemplate transactionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(messageProcessContext.getFlowConstruct().getMuleContext(), messageProcessContext.getFlowConstruct(), messageProcessContext.getTransactionConfig().orElse(new MuleTransactionConfig()), exceptionHandler);
                    Object response = transactionTemplate.execute(() -> {
                        Event muleEvent = template.getEvent();
                        this.fireNotification(messageSource, muleEvent, messageProcessContext.getFlowConstruct(), 801);
                        return template.routeEvent(muleEvent);
                    });
                    this.fireNotification(messageSource, (Event)response, messageProcessContext.getFlowConstruct(), 805);
                    template.sendResponseToClient((Event)response, this.createResponseCompletationCallback(phaseResultNotifier, exceptionHandler));
                }
                catch (MessagingException e) {
                    this.fireNotification(messageSource, e.getEvent(), messageProcessContext.getFlowConstruct(), 806);
                    template.sendFailureResponseToClient(e, this.createSendFailureResponseCompletationCallback(phaseResultNotifier));
                }
            }
            catch (Exception e) {
                phaseResultNotifier.phaseFailure(e);
            }
        };
        if (messageProcessContext.supportsAsynchronousProcessing()) {
            try {
                messageProcessContext.getFlowExecutionExecutor().execute(flowExecutionWork);
            }
            catch (SchedulerBusyException e) {
                phaseResultNotifier.phaseFailure(e);
            }
        } else {
            flowExecutionWork.run();
        }
    }

    private ResponseCompletionCallback createSendFailureResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public Event responseSentWithFailure(MessagingException e, Event event) {
                phaseResultNotifier.phaseFailure(e);
                return event;
            }
        };
    }

    private ResponseCompletionCallback createResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier, final MessagingExceptionHandler exceptionListener) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public Event responseSentWithFailure(MessagingException e, Event event) {
                return AsyncResponseFlowProcessingPhase.this.executeCallback(() -> {
                    Event exceptionStrategyResult = exceptionListener.handleException(e, event);
                    phaseResultNotifier.phaseSuccessfully();
                    return exceptionStrategyResult;
                }, phaseResultNotifier);
            }
        };
    }

    private Event executeCallback(Callback callback, PhaseResultNotifier phaseResultNotifier) {
        try {
            return callback.execute();
        }
        catch (Exception callbackException) {
            phaseResultNotifier.phaseFailure(callbackException);
            throw new MuleRuntimeException(callbackException);
        }
    }

    @Override
    public int compareTo(MessageProcessPhase messageProcessPhase) {
        if (messageProcessPhase instanceof ValidationPhase) {
            return 1;
        }
        return 0;
    }

    private static interface Callback {
        public Event execute() throws Exception;
    }
}

