/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.interception;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.message.ErrorBuilder;
import org.mule.runtime.core.el.BindingContextUtils;
import org.mule.runtime.core.internal.interception.InternalInterceptionEvent;

public class DefaultInterceptionEvent
implements InternalInterceptionEvent {
    public static final String INTERCEPTION_RESOLVED_PARAMS = "core:interceptionResolvedParams";
    public static final String INTERCEPTION_RESOLVED_CONTEXT = "core:interceptionResolvedContext";
    private Event interceptedInput;
    private Event.Builder interceptedOutput;

    public DefaultInterceptionEvent(Event interceptedInput) {
        this.interceptedInput = interceptedInput;
        this.interceptedOutput = Event.builder(interceptedInput);
    }

    @Override
    public Message getMessage() {
        return this.interceptedInput.getMessage();
    }

    @Override
    public <T> TypedValue<T> getVariable(String key) {
        return this.interceptedInput.getVariable(key);
    }

    @Override
    public Set<String> getVariableNames() {
        return this.interceptedInput.getVariableNames();
    }

    @Override
    public Optional<Error> getError() {
        return this.interceptedInput.getError();
    }

    public EventContext getContext() {
        return this.interceptedInput.getContext();
    }

    @Override
    public MuleSession getSession() {
        return this.interceptedInput.getSession();
    }

    @Override
    public DefaultInterceptionEvent message(Message message) {
        this.interceptedOutput = this.interceptedOutput.message(message);
        return this;
    }

    @Override
    public DefaultInterceptionEvent variables(Map<String, Object> variables) {
        this.interceptedOutput = this.interceptedOutput.variables(variables);
        return this;
    }

    @Override
    public DefaultInterceptionEvent addVariable(String key, Object value) {
        this.interceptedOutput = this.interceptedOutput.addVariable(key, value);
        return this;
    }

    @Override
    public DefaultInterceptionEvent addVariable(String key, Object value, DataType mediaType) {
        this.interceptedOutput = this.interceptedOutput.addVariable(key, value, mediaType);
        return this;
    }

    @Override
    public DefaultInterceptionEvent removeVariable(String key) {
        this.interceptedOutput = this.interceptedOutput.removeVariable(key);
        return this;
    }

    @Override
    public DefaultInterceptionEvent session(MuleSession session) {
        this.interceptedOutput = this.interceptedOutput.session(session);
        return this;
    }

    public DefaultInterceptionEvent setError(ErrorType errorType, Throwable cause) {
        ErrorBuilder errorBuilder = ErrorBuilder.builder(cause);
        errorBuilder.errorType(errorType);
        this.interceptedOutput = this.interceptedOutput.error(errorBuilder.build());
        return this;
    }

    @Override
    public BindingContext asBindingContext() {
        return BindingContextUtils.addEventBindings(this.resolve(), BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    public Event resolve() {
        Event newEvent = this.interceptedOutput.build();
        if (this.interceptedInput != newEvent) {
            this.interceptedInput = newEvent;
            this.interceptedOutput = Event.builder(this.interceptedInput).removeParameter(INTERCEPTION_RESOLVED_PARAMS);
        }
        return this.interceptedInput;
    }

    public Event getInterceptionResult() {
        return this.interceptedInput;
    }
}

