/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.activation.DataHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;
import org.mule.runtime.core.PropertyScope;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.message.ExceptionPayload;
import org.mule.runtime.core.api.store.DeserializationPostInitialisable;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.ObjectUtils;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.metadata.DefaultCollectionDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageBuilder
implements InternalMessage.Builder,
InternalMessage.PayloadBuilder,
InternalMessage.AttributesBuilder,
InternalMessage.CollectionBuilder {
    private Object payload;
    private DataType dataType;
    private Object attributes = NullAttributes.NULL_ATTRIBUTES;
    private DataType attributesDataType;
    private ExceptionPayload exceptionPayload;
    private Map<String, TypedValue<Serializable>> inboundProperties = new CaseInsensitiveMapWrapper<TypedValue<Serializable>>();
    private Map<String, TypedValue<Serializable>> outboundProperties = new CaseInsensitiveMapWrapper<TypedValue<Serializable>>();
    private Map<String, DataHandler> inboundAttachments = new HashMap<String, DataHandler>();
    private Map<String, DataHandler> outboundAttachments = new HashMap<String, DataHandler>();

    public DefaultMessageBuilder() {
    }

    private void copyMessageAttributes(InternalMessage message) {
        this.exceptionPayload = message.getExceptionPayload();
        message.getInboundPropertyNames().forEach(key -> {
            if (message.getInboundPropertyDataType((String)key) != null) {
                this.addInboundProperty((String)key, (Serializable)message.getInboundProperty((String)key), message.getInboundPropertyDataType((String)key));
            } else {
                this.addInboundProperty((String)key, (Serializable)message.getInboundProperty((String)key));
            }
        });
        message.getOutboundPropertyNames().forEach(key -> {
            if (message.getOutboundPropertyDataType((String)key) != null) {
                this.addOutboundProperty((String)key, (Serializable)message.getOutboundProperty((String)key), message.getOutboundPropertyDataType((String)key));
            } else {
                this.addOutboundProperty((String)key, (Serializable)message.getOutboundProperty((String)key));
            }
        });
        message.getInboundAttachmentNames().forEach(name -> this.addInboundAttachment((String)name, message.getInboundAttachment((String)name)));
        message.getOutboundAttachmentNames().forEach(name -> this.addOutboundAttachment((String)name, message.getOutboundAttachment((String)name)));
    }

    public DefaultMessageBuilder(Message message) {
        Objects.requireNonNull(message);
        this.payload = message.getPayload().getValue();
        this.dataType = message.getPayload().getDataType();
        this.attributes = message.getAttributes().getValue();
        this.attributesDataType = message.getAttributes().getDataType();
        if (message instanceof InternalMessage) {
            this.copyMessageAttributes((InternalMessage)message);
        }
    }

    @Override
    public InternalMessage.Builder nullPayload() {
        this.payload = null;
        return this;
    }

    @Override
    public InternalMessage.Builder payload(Object payload) {
        this.payload = payload;
        return this;
    }

    @Override
    public InternalMessage.Builder mediaType(MediaType mediaType) {
        this.dataType = DataType.builder().mediaType(mediaType).build();
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder streamPayload(Iterator payload, Class<?> clazz) {
        Objects.requireNonNull(payload);
        this.payload = payload;
        this.dataType = DataType.builder().streamType(payload.getClass()).itemType(clazz).build();
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder collectionPayload(Collection payload, Class<?> clazz) {
        Objects.requireNonNull(payload);
        this.payload = payload;
        this.dataType = DataType.builder().collectionType(payload.getClass()).itemType(clazz).build();
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder collectionPayload(Object[] payload) {
        Objects.requireNonNull(payload);
        return this.collectionPayload((Collection)Arrays.asList(payload), (Class)payload.getClass().getComponentType());
    }

    @Override
    public InternalMessage.CollectionBuilder itemMediaType(MediaType mediaType) {
        if (!(this.dataType instanceof DefaultCollectionDataType)) {
            throw new IllegalStateException("Item MediaType cannot be set, because payload is not a collection");
        }
        this.dataType = ((DataTypeBuilder.DataTypeCollectionTypeBuilder)((Object)DataType.builder(this.dataType))).itemMediaType(mediaType).build();
        return this;
    }

    @Override
    public InternalMessage.Builder nullAttributes() {
        this.attributes = NullAttributes.NULL_ATTRIBUTES;
        return this;
    }

    @Override
    public InternalMessage.Builder attributes(Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public InternalMessage.Builder attributesMediaType(MediaType mediaType) {
        this.attributesDataType = DataType.builder().mediaType(mediaType).build();
        return this;
    }

    @Override
    public InternalMessage.Builder exceptionPayload(ExceptionPayload exceptionPayload) {
        this.exceptionPayload = exceptionPayload;
        return this;
    }

    @Override
    public InternalMessage.Builder addInboundProperty(String key, Serializable value) {
        this.inboundProperties.put(key, new TypedValue<Serializable>(value, value != null ? DataType.fromObject(value) : DataType.OBJECT));
        return this;
    }

    @Override
    public InternalMessage.Builder addInboundProperty(String key, Serializable value, MediaType mediaType) {
        this.inboundProperties.put(key, new TypedValue<Serializable>(value, DataType.builder().type(value.getClass()).mediaType(mediaType).build()));
        return this;
    }

    @Override
    public InternalMessage.Builder addInboundProperty(String key, Serializable value, DataType dataType) {
        this.inboundProperties.put(key, new TypedValue<Serializable>(value, dataType));
        return this;
    }

    @Override
    public InternalMessage.Builder addOutboundProperty(String key, Serializable value) {
        this.outboundProperties.put(key, new TypedValue<Serializable>(value, value != null ? DataType.fromObject(value) : DataType.OBJECT));
        return this;
    }

    @Override
    public InternalMessage.Builder addOutboundProperty(String key, Serializable value, MediaType mediaType) {
        this.outboundProperties.put(key, new TypedValue<Serializable>(value, DataType.builder().type(value.getClass()).mediaType(mediaType).build()));
        return this;
    }

    @Override
    public InternalMessage.Builder addOutboundProperty(String key, Serializable value, DataType dataType) {
        this.outboundProperties.put(key, new TypedValue<Serializable>(value, dataType));
        return this;
    }

    @Override
    public InternalMessage.Builder removeInboundProperty(String key) {
        this.inboundProperties.remove(key);
        return this;
    }

    @Override
    public InternalMessage.Builder removeOutboundProperty(String key) {
        this.outboundProperties.remove(key);
        return this;
    }

    @Override
    public InternalMessage.Builder addInboundAttachment(String key, DataHandler value) {
        this.inboundAttachments.put(key, value);
        return this;
    }

    @Override
    public InternalMessage.Builder addOutboundAttachment(String key, DataHandler value) {
        this.outboundAttachments.put(key, value);
        return this;
    }

    @Override
    public InternalMessage.Builder removeInboundAttachment(String key) {
        this.inboundAttachments.remove(key);
        return this;
    }

    @Override
    public InternalMessage.Builder removeOutboundAttachment(String key) {
        this.outboundAttachments.remove(key);
        return this;
    }

    @Override
    public InternalMessage.Builder inboundProperties(Map<String, Serializable> inboundProperties) {
        Objects.requireNonNull(inboundProperties);
        this.inboundProperties.clear();
        inboundProperties.forEach((s, serializable) -> this.addInboundProperty((String)s, (Serializable)serializable));
        return this;
    }

    @Override
    public InternalMessage.Builder outboundProperties(Map<String, Serializable> outboundProperties) {
        Objects.requireNonNull(outboundProperties);
        this.outboundProperties.clear();
        outboundProperties.forEach((s, serializable) -> this.addOutboundProperty((String)s, (Serializable)serializable));
        return this;
    }

    @Override
    public InternalMessage.Builder inboundAttachments(Map<String, DataHandler> inboundAttachments) {
        Objects.requireNonNull(inboundAttachments);
        this.inboundAttachments = new HashMap<String, DataHandler>(inboundAttachments);
        return this;
    }

    @Override
    public InternalMessage.Builder outboundAttachments(Map<String, DataHandler> outbundAttachments) {
        Objects.requireNonNull(outbundAttachments);
        this.outboundAttachments = new HashMap<String, DataHandler>(outbundAttachments);
        return this;
    }

    @Override
    public InternalMessage build() {
        return new MessageImplementation(new TypedValue<Object>(this.payload, this.resolveDataType()), new TypedValue<Object>(this.attributes, this.resolveAttributesDataType()), this.inboundProperties, this.outboundProperties, this.inboundAttachments, this.outboundAttachments, this.exceptionPayload);
    }

    private DataType resolveDataType() {
        if (this.dataType == null) {
            return DataType.fromObject(this.payload);
        }
        return DataType.builder(this.dataType).fromObject(this.payload).build();
    }

    private DataType resolveAttributesDataType() {
        if (this.attributesDataType == null) {
            return DataType.fromObject(this.attributes);
        }
        return DataType.builder(this.attributesDataType).fromObject(this.attributes).build();
    }

    public static Class getMessageImplementationClass() {
        return MessageImplementation.class;
    }

    private static class MessageImplementation
    implements InternalMessage,
    DeserializationPostInitialisable {
        private static final String NOT_SET = "<not set>";
        private static final long serialVersionUID = 1541720810851984845L;
        private static final Logger logger = LoggerFactory.getLogger(MessageImplementation.class);
        private ExceptionPayload exceptionPayload;
        private transient Map<String, DataHandler> inboundAttachments = new HashMap<String, DataHandler>();
        private transient Map<String, DataHandler> outboundAttachments = new HashMap<String, DataHandler>();
        private transient TypedValue typedValue;
        private TypedValue typedAttributes;
        private Map<String, TypedValue<Serializable>> inboundMap = new CaseInsensitiveMapWrapper<TypedValue<Serializable>>();
        private Map<String, TypedValue<Serializable>> outboundMap = new CaseInsensitiveMapWrapper<TypedValue<Serializable>>();

        private MessageImplementation(TypedValue typedValue, TypedValue typedAttributes, Map<String, TypedValue<Serializable>> inboundProperties, Map<String, TypedValue<Serializable>> outboundProperties, Map<String, DataHandler> inboundAttachments, Map<String, DataHandler> outboundAttachments, ExceptionPayload exceptionPayload) {
            this.typedValue = typedValue;
            this.typedAttributes = typedAttributes;
            this.inboundMap.putAll(inboundProperties);
            this.outboundMap.putAll(outboundProperties);
            this.inboundAttachments = inboundAttachments;
            this.outboundAttachments = outboundAttachments;
            this.exceptionPayload = exceptionPayload;
        }

        @Override
        public ExceptionPayload getExceptionPayload() {
            return this.exceptionPayload;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(120);
            buf.append(System.lineSeparator());
            buf.append(this.getClass().getName());
            buf.append(System.lineSeparator());
            buf.append("{");
            buf.append(System.lineSeparator());
            buf.append("  payload=").append(this.getPayload().getDataType().getType().getName());
            buf.append(System.lineSeparator());
            buf.append("  mediaType=").append(this.getPayload().getDataType().getMediaType());
            buf.append(System.lineSeparator());
            buf.append("  attributes=").append(this.getAttributes().getValue().toString());
            buf.append(System.lineSeparator());
            buf.append("  exceptionPayload=").append(org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)this.exceptionPayload, (Object)NOT_SET));
            buf.append(System.lineSeparator());
            if (!this.getInboundPropertyNames().isEmpty() || !this.getOutboundPropertyNames().isEmpty()) {
                MessageImplementation.headersToStringBuilder(this, buf);
            }
            buf.append('}');
            return buf.toString();
        }

        public static void headersToStringBuilder(InternalMessage m, StringBuilder buf) {
            buf.append("  Message properties:").append(System.lineSeparator());
            try {
                if (!m.getInboundPropertyNames().isEmpty()) {
                    TreeSet<String> inboundNames = new TreeSet<String>(m.getInboundPropertyNames());
                    buf.append("    ").append(PropertyScope.INBOUND.toString().toUpperCase()).append(" scoped properties:").append(System.lineSeparator());
                    MessageImplementation.appendPropertyValues(m, buf, inboundNames, name -> m.getInboundProperty((String)name));
                }
                if (!m.getOutboundPropertyNames().isEmpty()) {
                    TreeSet<String> outboundNames = new TreeSet<String>(m.getOutboundPropertyNames());
                    buf.append("    ").append(PropertyScope.OUTBOUND.toString().toUpperCase()).append(" scoped properties:").append(System.lineSeparator());
                    MessageImplementation.appendPropertyValues(m, buf, outboundNames, name -> m.getOutboundProperty((String)name));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private static void appendPropertyValues(InternalMessage m, StringBuilder buf, Set<String> names, Function<String, Serializable> valueResolver) {
            for (String name : names) {
                Object value = valueResolver.apply(name);
                if (value instanceof InternalMessage) {
                    value = "<<<Message>>>";
                }
                if (name.equals("password") || name.toString().contains("secret") || name.equals("pass")) {
                    value = "****";
                }
                buf.append("    ").append(name).append("=").append(value).append(System.lineSeparator());
            }
        }

        @Override
        public DataHandler getInboundAttachment(String name) {
            return this.inboundAttachments.get(name);
        }

        @Override
        public DataHandler getOutboundAttachment(String name) {
            return this.outboundAttachments.get(name);
        }

        @Override
        public Set<String> getInboundAttachmentNames() {
            return Collections.unmodifiableSet(this.inboundAttachments.keySet());
        }

        @Override
        public Set<String> getOutboundAttachmentNames() {
            return Collections.unmodifiableSet(this.outboundAttachments.keySet());
        }

        public TypedValue getPayload() {
            return this.typedValue;
        }

        private void writeObject(ObjectOutputStream out) throws Exception {
            out.defaultWriteObject();
            this.serializeValue(out);
            out.writeObject(this.serializeAttachments(this.inboundAttachments));
            out.writeObject(this.serializeAttachments(this.outboundAttachments));
        }

        private Map<String, SerializedDataHandler> serializeAttachments(Map<String, DataHandler> attachments) throws IOException {
            HashMap<String, SerializedDataHandler> toWrite;
            if (attachments == null) {
                toWrite = null;
            } else {
                toWrite = new HashMap<String, SerializedDataHandler>(attachments.size());
                for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
                    String name = entry.getKey();
                    toWrite.put(name, new SerializedDataHandler(name, entry.getValue(), Event.getCurrentEvent().getMuleContext()));
                }
            }
            return toWrite;
        }

        protected void serializeValue(ObjectOutputStream out) throws Exception {
            if (this.typedValue.getValue() == null || this.typedValue.getValue() instanceof Serializable) {
                out.writeBoolean(true);
                out.writeObject(this.typedValue.getValue());
                out.writeObject(this.typedValue.getDataType());
            } else {
                out.writeBoolean(false);
                byte[] valueAsByteArray = (byte[])Event.getCurrentEvent().getMuleContext().getTransformationService().internalTransform(this, DataType.BYTE_ARRAY).getPayload().getValue();
                out.writeInt(valueAsByteArray.length);
                new DataOutputStream(out).write(valueAsByteArray);
                out.writeObject(DataType.BYTE_ARRAY);
            }
        }

        protected Object deserializeValue(ObjectInputStream in) throws Exception {
            if (in.readBoolean()) {
                return in.readObject();
            }
            int length = in.readInt();
            byte[] valueAsByteArray = new byte[length];
            new DataInputStream(in).readFully(valueAsByteArray);
            return valueAsByteArray;
        }

        private Map<String, DataHandler> deserializeAttachments(Map<String, SerializedDataHandler> attachments) throws IOException {
            Map<String, DataHandler> toReturn;
            if (attachments == null) {
                toReturn = Collections.emptyMap();
            } else {
                toReturn = new HashMap<String, DataHandler>(attachments.size());
                for (Map.Entry<String, SerializedDataHandler> entry : attachments.entrySet()) {
                    toReturn.put(entry.getKey(), entry.getValue().getHandler());
                }
            }
            return toReturn;
        }

        private void readObject(ObjectInputStream in) throws Exception {
            in.defaultReadObject();
            this.typedValue = new TypedValue<Object>(this.deserializeValue(in), (DataType)in.readObject());
            this.inboundAttachments = this.deserializeAttachments((Map)in.readObject());
            this.outboundAttachments = this.deserializeAttachments((Map)in.readObject());
        }

        public void initAfterDeserialisation(MuleContext context) throws MuleException {
            if (this.inboundAttachments == null) {
                this.inboundAttachments = new HashMap<String, DataHandler>();
            }
            if (this.outboundAttachments == null) {
                this.outboundAttachments = new HashMap<String, DataHandler>();
            }
        }

        public TypedValue getAttributes() {
            return this.typedAttributes;
        }

        public Serializable getInboundProperty(String name) {
            return this.getInboundProperty(name, null);
        }

        @Override
        public <T extends Serializable> T getInboundProperty(String name, T defaultValue) {
            return (T)this.getValueOrDefault(this.inboundMap.get(name), defaultValue);
        }

        public Serializable getOutboundProperty(String name) {
            return this.getOutboundProperty(name, null);
        }

        @Override
        public <T extends Serializable> T getOutboundProperty(String name, T defaultValue) {
            return (T)this.getValueOrDefault(this.outboundMap.get(name), defaultValue);
        }

        @Override
        public Set<String> getInboundPropertyNames() {
            return Collections.unmodifiableSet(this.inboundMap.keySet());
        }

        @Override
        public Set<String> getOutboundPropertyNames() {
            return Collections.unmodifiableSet(this.outboundMap.keySet());
        }

        @Override
        public DataType getInboundPropertyDataType(String name) {
            TypedValue<Serializable> typedValue = this.inboundMap.get(name);
            return typedValue == null ? null : typedValue.getDataType();
        }

        @Override
        public DataType getOutboundPropertyDataType(String name) {
            TypedValue<Serializable> typedValue = this.outboundMap.get(name);
            return typedValue == null ? null : typedValue.getDataType();
        }

        private <T extends Serializable> T getValueOrDefault(TypedValue<T> typedValue, T defaultValue) {
            if (typedValue == null) {
                return defaultValue;
            }
            Serializable value = (Serializable)typedValue.getValue();
            if (defaultValue == null) {
                return (T)value;
            }
            if (defaultValue instanceof Boolean) {
                return (T)Boolean.valueOf(ObjectUtils.getBoolean(value, (Boolean)defaultValue));
            }
            if (defaultValue instanceof Byte) {
                return (T)Byte.valueOf(ObjectUtils.getByte(value, (Byte)defaultValue));
            }
            if (defaultValue instanceof Integer) {
                return (T)Integer.valueOf(ObjectUtils.getInt(value, (Integer)defaultValue));
            }
            if (defaultValue instanceof Short) {
                return (T)Short.valueOf(ObjectUtils.getShort(value, (Short)defaultValue));
            }
            if (defaultValue instanceof Long) {
                return (T)Long.valueOf(ObjectUtils.getLong(value, (Long)defaultValue));
            }
            if (defaultValue instanceof Float) {
                return (T)Float.valueOf(ObjectUtils.getFloat(value, (Float)defaultValue));
            }
            if (defaultValue instanceof Double) {
                return (T)Double.valueOf(ObjectUtils.getDouble(value, (Double)defaultValue));
            }
            if (defaultValue instanceof String) {
                return (T)ObjectUtils.getString(value, (String)((Object)defaultValue));
            }
            if (value == null) {
                return defaultValue;
            }
            if (defaultValue.getClass().isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            throw new IllegalArgumentException(CoreMessages.objectNotOfCorrectType(value.getClass(), defaultValue.getClass()).getMessage());
        }

        public static class SerializedDataHandler
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private DataHandler handler;
            private String contentType;
            private Object contents;

            public SerializedDataHandler(String name, DataHandler handler, MuleContext muleContext) throws IOException {
                if (handler != null && !(handler instanceof Serializable)) {
                    this.contentType = handler.getContentType();
                    Object theContent = handler.getContent();
                    if (theContent instanceof Serializable) {
                        this.contents = theContent;
                    } else {
                        try {
                            DataType source = DataType.fromObject(theContent);
                            Transformer transformer = muleContext.getRegistry().lookupTransformer(source, DataType.BYTE_ARRAY);
                            if (transformer == null) {
                                throw new TransformerException(CoreMessages.noTransformerFoundForMessage(source, DataType.BYTE_ARRAY));
                            }
                            this.contents = transformer.transform(theContent);
                        }
                        catch (TransformerException ex) {
                            String message = String.format("Unable to serialize the attachment %s, which is of type %s with contents of type %s", name, handler.getClass(), theContent.getClass());
                            logger.error(message);
                            throw new IOException(message);
                        }
                    }
                } else {
                    this.handler = handler;
                }
            }

            public DataHandler getHandler() {
                return this.contents != null ? new DataHandler(this.contents, this.contentType) : this.handler;
            }
        }
    }
}

