/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.Collection;
import java.util.Optional;
import org.mule.runtime.api.artifact.ServiceDiscoverer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.RegistrationException;

public class DefaultServiceDiscoverer
implements ServiceDiscoverer {
    private MuleContext muleContext;

    public DefaultServiceDiscoverer(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public <T> Optional<T> lookup(Class<T> serviceType) {
        try {
            return Optional.ofNullable(this.muleContext.getRegistry().lookupObject(serviceType));
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public <T> Optional<T> lookupByName(String name) {
        return Optional.ofNullable(this.muleContext.getRegistry().lookupObject(name));
    }

    @Override
    public <T> Collection<T> lookupAll(Class<T> serviceType) {
        return this.muleContext.getRegistry().lookupObjects(serviceType);
    }
}

