/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.retry.policies;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.mule.runtime.core.api.retry.policy.PolicyStatus;
import org.mule.runtime.core.api.retry.policy.RetryPolicy;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public class SimpleRetryPolicy
implements RetryPolicy {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleRetryPolicy.class);
    protected RetryCounter retryCounter;
    private volatile int count = 2;
    private volatile long frequency = 2000L;

    public SimpleRetryPolicy(long frequency, int retryCount) {
        this.frequency = frequency;
        this.count = retryCount;
        this.retryCounter = new RetryCounter();
    }

    @Override
    public <T> Publisher<T> applyPolicy(Publisher<T> publisher, Predicate<Throwable> shouldRetry, Consumer<Throwable> onExhausted) {
        int actualCount = this.count + 1;
        return Flux.from(publisher).retryWhen(errors -> errors.zipWith((Publisher)Flux.range((int)1, (int)actualCount), Tuples::of).flatMap(tuple -> {
            Throwable exception = (Throwable)tuple.getT1();
            if ((Integer)tuple.getT2() == actualCount || !shouldRetry.test(exception)) {
                onExhausted.accept(exception);
                return Mono.error((Throwable)exception);
            }
            return Mono.delay((Duration)Duration.ofMillis(this.frequency));
        }));
    }

    @Override
    public PolicyStatus applyPolicy(Throwable cause) {
        if (this.isExhausted() || !this.isApplicableTo(cause)) {
            return PolicyStatus.policyExhausted(cause);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Waiting for " + this.frequency + "ms before reconnecting. Failed attempt " + (this.retryCounter.current().get() + 1) + " of " + (this.count != -1 ? String.valueOf(this.count) : "unlimited"));
        }
        try {
            this.retryCounter.current().getAndIncrement();
            Thread.sleep(this.frequency);
            return PolicyStatus.policyOk();
        }
        catch (InterruptedException e) {
            return PolicyStatus.policyExhausted(e);
        }
    }

    protected boolean isApplicableTo(Throwable cause) {
        return true;
    }

    protected boolean isExhausted() {
        return this.count != -1 && this.retryCounter.current().get() >= this.count;
    }

    protected static class RetryCounter
    extends ThreadLocal<AtomicInteger> {
        protected RetryCounter() {
        }

        public int countRetry() {
            return ((AtomicInteger)this.get()).incrementAndGet();
        }

        public void reset() {
            ((AtomicInteger)this.get()).set(0);
        }

        public AtomicInteger current() {
            return (AtomicInteger)this.get();
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    }
}

