/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.CompositeMessageSource;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartableCompositeMessageSource
extends AbstractAnnotatedObject
implements CompositeMessageSource,
Lifecycle,
FlowConstructAware,
MuleContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(StartableCompositeMessageSource.class);
    protected Processor listener;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected final List<MessageSource> sources = Collections.synchronizedList(new ArrayList());
    protected AtomicBoolean starting = new AtomicBoolean(false);
    protected FlowConstruct flowConstruct;
    private final Processor internalListener = new InternalMessageProcessor();
    protected MuleContext muleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSource(MessageSource source) throws MuleException {
        MessageSource messageSource = source;
        List<MessageSource> list = this.sources;
        synchronized (list) {
            this.sources.add(messageSource);
        }
        source.setListener(this.internalListener);
        if (this.initialised.get()) {
            this.initializeComposedMessageSource(messageSource);
        }
        if (this.started.get() && source instanceof Startable) {
            ((Startable)((Object)source)).start();
        }
    }

    private void initializeComposedMessageSource(MessageSource messageSource) throws InitialisationException {
        if (messageSource instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)messageSource)).setFlowConstruct(this.flowConstruct);
        }
        if (messageSource instanceof MuleContextAware) {
            ((MuleContextAware)((Object)messageSource)).setMuleContext(this.muleContext);
        }
        if (messageSource instanceof Initialisable) {
            ((Initialisable)((Object)messageSource)).initialise();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSource(MessageSource source) throws MuleException {
        if (this.started.get()) {
            if (source instanceof Stoppable) {
                ((Stoppable)((Object)source)).stop();
            }
            if (source instanceof Disposable) {
                ((Disposable)((Object)source)).dispose();
            }
        }
        List<MessageSource> list = this.sources;
        synchronized (list) {
            this.sources.remove(source);
        }
    }

    public void setMessageSources(List<MessageSource> sources) throws MuleException {
        this.sources.clear();
        for (MessageSource messageSource : sources) {
            this.addSource(messageSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        if (this.listener == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("listener"), (Initialisable)this);
        }
        List<MessageSource> list = this.sources;
        synchronized (list) {
            for (MessageSource source : this.sources) {
                this.initializeComposedMessageSource(source);
            }
        }
        this.initialised.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        if (this.listener == null) {
            throw new LifecycleException(CoreMessages.objectIsNull("listener"), (Object)this);
        }
        List<MessageSource> list = this.sources;
        synchronized (list) {
            this.starting.set(true);
            for (MessageSource source : this.sources) {
                if (!(source instanceof Startable)) continue;
                ((Startable)((Object)source)).start();
            }
            this.started.set(true);
            this.starting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        List<MessageSource> list = this.sources;
        synchronized (list) {
            for (MessageSource source : this.sources) {
                if (!(source instanceof Stoppable)) continue;
                ((Stoppable)((Object)source)).stop();
            }
            this.started.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<MessageSource> list = this.sources;
        synchronized (list) {
            for (MessageSource source : this.sources) {
                if (!(source instanceof Disposable)) continue;
                ((Disposable)((Object)source)).dispose();
            }
        }
    }

    @Override
    public void setListener(Processor listener) {
        this.listener = listener;
    }

    @Override
    public void setFlowConstruct(FlowConstruct pattern) {
        this.flowConstruct = pattern;
    }

    @Override
    public List<MessageSource> getSources() {
        return this.sources;
    }

    public String toString() {
        return String.format("%s [listener=%s, sources=%s, started=%s]", this.getClass().getSimpleName(), this.listener, this.sources, this.started);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private class InternalMessageProcessor
    extends AbstractAnnotatedObject
    implements Processor {
        @Override
        public Event process(Event event) throws MuleException {
            if (StartableCompositeMessageSource.this.started.get() || StartableCompositeMessageSource.this.starting.get()) {
                return StartableCompositeMessageSource.this.listener.process(event);
            }
            throw new IllegalStateException(String.format("A message was receieved from MessageSource, but CompositeMessageSource is stopped.%n  Message: %s%n  CompositeMessageSource: %s", event, this));
        }

        public String toString() {
            return ObjectUtils.toString(this);
        }
    }
}

