/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.codec;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.util.XMLEntityCodec;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class XmlEntityEncoder
extends AbstractTransformer {
    public XmlEntityEncoder() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.setReturnDataType(DataType.STRING);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        try {
            String data;
            if (src instanceof byte[]) {
                data = new String((byte[])src, encoding);
            } else if (src instanceof CursorStreamProvider) {
                try (InputStream in = (InputStream)((CursorStreamProvider)src).openCursor();){
                    data = IOUtils.toString((InputStream)in, (Charset)encoding);
                }
            } else {
                data = src instanceof InputStream ? IOUtils.toString((InputStream)((InputStream)src), (Charset)encoding) : (String)src;
            }
            return XMLEntityCodec.encodeString(data);
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed(src.getClass().getName(), "XML"), this, (Throwable)ex);
        }
    }
}

