/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.internal.streaming.object.iterator.StreamingIterator;
import org.mule.runtime.core.internal.util.message.ResultToMessageIterator;
import org.mule.runtime.core.internal.util.message.ResultToMessageStreamingIterator;
import org.mule.runtime.core.internal.util.message.ResultsToMessageCollection;
import org.mule.runtime.core.internal.util.message.ResultsToMessageList;
import org.mule.runtime.core.internal.util.message.ResultsToMessageSet;
import org.mule.runtime.core.streaming.CursorProviderFactory;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static Message toMessage(Result result) {
        return MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY));
    }

    public static Message toMessage(Result result, MediaType mediaType) {
        return MessageUtils.toMessage(result, mediaType, null, null);
    }

    public static Message toMessage(Result result, CursorProviderFactory cursorProviderFactory, Event event) {
        return MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY), cursorProviderFactory, event);
    }

    public static Message toMessage(Result result, MediaType mediaType, CursorProviderFactory cursorProviderFactory, Event event) {
        return Message.builder().payload(StreamingUtils.streamingContent(result.getOutput(), cursorProviderFactory, event)).mediaType(mediaType).attributes(result.getAttributes().orElse(NullAttributes.NULL_ATTRIBUTES)).build();
    }

    public static Collection<Message> toMessageCollection(Collection<Result> results, CursorProviderFactory cursorProviderFactory, Event event) {
        if (results instanceof List) {
            return new ResultsToMessageList((List)results, cursorProviderFactory, event);
        }
        if (results instanceof Set) {
            return new ResultsToMessageSet((Set)results, cursorProviderFactory, event);
        }
        return new ResultsToMessageCollection(results, cursorProviderFactory, event);
    }

    public static Iterator<Message> toMessageIterator(Iterator<Result> results, CursorProviderFactory cursorProviderFactory, Event event) {
        if (results instanceof StreamingIterator) {
            return new ResultToMessageStreamingIterator((StreamingIterator)results, cursorProviderFactory, event);
        }
        return new ResultToMessageIterator(results, cursorProviderFactory, event);
    }
}

