/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.internal.util.queue.LocalQueueTransactionContext;
import org.mule.runtime.core.internal.util.queue.QueueStore;

public class TransientQueueTransactionContext
implements LocalQueueTransactionContext {
    private static final int CLEAR_POLL_TIMEOUT = 10;
    private Map<QueueStore, List<Serializable>> added;
    private Map<QueueStore, List<Serializable>> removed;

    @Override
    public boolean offer(QueueStore queue, Serializable item, long offerTimeout) throws InterruptedException {
        this.initializeAdded();
        List<Serializable> queueAdded = this.lookupAddedQueue(queue);
        if (queue.offer(null, queueAdded.size(), offerTimeout)) {
            queueAdded.add(item);
            return true;
        }
        return false;
    }

    @Override
    public void untake(QueueStore queue, Serializable item) throws InterruptedException {
        this.initializeAdded();
        List<Serializable> queueAdded = this.lookupAddedQueue(queue);
        queueAdded.add(item);
    }

    @Override
    public void clear(QueueStore queue) throws InterruptedException {
        List<Serializable> queueAdded;
        this.initializeRemoved();
        List<Serializable> queueRemoved = this.lookupRemovedQueue(queue);
        Serializable discardedItem = queue.poll(10L);
        while (discardedItem != null) {
            queueRemoved.add(discardedItem);
            discardedItem = queue.poll(10L);
        }
        if (this.added != null && !CollectionUtils.isEmpty(queueAdded = this.lookupAddedQueue(queue))) {
            queueRemoved.addAll(queueAdded);
            queueAdded.clear();
        }
    }

    @Override
    public Serializable poll(QueueStore queue, long pollTimeout) throws InterruptedException {
        Serializable value = queue.poll(pollTimeout);
        if (value != null) {
            List<Serializable> queueRemoved;
            if (this.removed == null) {
                this.removed = new HashMap<QueueStore, List<Serializable>>();
            }
            if ((queueRemoved = this.removed.get(queue)) == null) {
                queueRemoved = new ArrayList<Serializable>();
                this.removed.put(queue, queueRemoved);
            }
            queueRemoved.add(value);
        }
        return value;
    }

    @Override
    public Serializable peek(QueueStore queue) throws InterruptedException {
        return queue.peek();
    }

    @Override
    public int size(QueueStore queue) {
        List<Serializable> queueAdded;
        int sz = queue.getSize();
        if (this.added != null && (queueAdded = this.added.get(queue)) != null) {
            sz += queueAdded.size();
        }
        return sz;
    }

    @Override
    public void doCommit() throws ResourceManagerException {
        try {
            if (this.added != null) {
                for (Map.Entry<QueueStore, List<Serializable>> entry : this.added.entrySet()) {
                    QueueStore queue = entry.getKey();
                    List<Serializable> queueAdded = entry.getValue();
                    if (queueAdded == null || queueAdded.size() <= 0) continue;
                    for (Serializable object : queueAdded) {
                        queue.putNow(object);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ResourceManagerException(e);
        }
        finally {
            this.added = null;
            this.removed = null;
        }
    }

    @Override
    public void doRollback() throws ResourceManagerException {
        if (this.removed != null) {
            for (Map.Entry<QueueStore, List<Serializable>> entry : this.removed.entrySet()) {
                QueueStore queue = entry.getKey();
                List<Serializable> queueRemoved = entry.getValue();
                if (queueRemoved == null || queueRemoved.size() <= 0) continue;
                for (Serializable id : queueRemoved) {
                    try {
                        queue.putNow(id);
                    }
                    catch (InterruptedException e) {
                        throw new MuleRuntimeException(e);
                    }
                }
            }
        }
        this.added = null;
        this.removed = null;
    }

    protected void initializeAdded() {
        if (this.added == null) {
            this.added = new HashMap<QueueStore, List<Serializable>>();
        }
    }

    protected void initializeRemoved() {
        if (this.removed == null) {
            this.removed = new HashMap<QueueStore, List<Serializable>>();
        }
    }

    protected List<Serializable> lookupAddedQueue(QueueStore queue) {
        List<Serializable> queueAdded = this.added.get(queue);
        if (queueAdded == null) {
            queueAdded = new ArrayList<Serializable>();
            this.added.put(queue, queueAdded);
        }
        return queueAdded;
    }

    protected List<Serializable> lookupRemovedQueue(QueueStore queue) {
        List<Serializable> queueRemoved = this.removed.get(queue);
        if (queueRemoved == null) {
            queueRemoved = new ArrayList<Serializable>();
            this.removed.put(queue, queueRemoved);
        }
        return queueRemoved;
    }
}

