/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonitoredObjectStore<T extends Serializable>
implements ObjectStore<T>,
Runnable,
MuleContextAware,
Initialisable,
Disposable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext context;
    private Scheduler scheduler;
    private ScheduledFuture<?> scheduledTask;
    protected int maxEntries = 4000;
    protected int entryTTL = -1;
    protected int expirationInterval = 1000;
    protected String name = null;

    @Override
    public void initialise() throws InitialisationException {
        if (this.name == null) {
            this.name = UUID.getUUID();
        }
        if (this.expirationInterval <= 0) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("expirationInterval", new Integer(this.expirationInterval)).toString());
        }
        if (this.scheduler == null) {
            this.scheduler = this.context.getSchedulerService().customScheduler(this.context.getSchedulerBaseConfig().withName(this.name + "-Monitor").withMaxConcurrentTasks(1));
            this.scheduledTask = this.scheduler.scheduleWithFixedDelay(this, 0L, this.expirationInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public final void run() {
        if (this.context == null || this.context.isPrimaryPollingInstance()) {
            this.expire();
        }
    }

    @Override
    public void dispose() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
            this.scheduler.stop();
        }
    }

    protected MuleContext getMuleContext() {
        return this.context;
    }

    public void setEntryTTL(int entryTTL) {
        this.entryTTL = entryTTL;
    }

    public void setExpirationInterval(int expirationInterval) {
        this.expirationInterval = expirationInterval;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setName(String id) {
        this.name = id;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public int getEntryTTL() {
        return this.entryTTL;
    }

    public int getExpirationInterval() {
        return this.expirationInterval;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public String getName() {
        return this.name;
    }

    protected abstract void expire();
}

