/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.AbstractCompositePolicy;
import org.mule.runtime.core.policy.FlowExecutionException;
import org.mule.runtime.core.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.SourcePolicy;
import org.mule.runtime.core.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.policy.SourcePolicySuccessResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CompositeSourcePolicy
extends AbstractCompositePolicy<SourcePolicyParametersTransformer, MessageSourceResponseParametersProcessor>
implements SourcePolicy {
    private final Processor flowExecutionProcessor;
    private final SourcePolicyProcessorFactory sourcePolicyProcessorFactory;
    private Map<String, Object> originalResponseParameters;
    private Map<String, Object> originalFailureResponseParameters;

    public CompositeSourcePolicy(List<Policy> parameterizedPolicies, Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer, SourcePolicyProcessorFactory sourcePolicyProcessorFactory, Processor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        super(parameterizedPolicies, sourcePolicyParametersTransformer, messageSourceResponseParametersProcessor);
        this.sourcePolicyProcessorFactory = sourcePolicyProcessorFactory;
        this.flowExecutionProcessor = flowExecutionProcessor;
    }

    @Override
    protected Publisher<Event> processNextOperation(Event event) {
        return Mono.just((Object)event).then(request -> Mono.from(MessageProcessors.processWithChildContext(request, this.flowExecutionProcessor))).map(flowExecutionResponse -> {
            this.originalResponseParameters = ((MessageSourceResponseParametersProcessor)this.getParametersProcessor()).getSuccessfulExecutionResponseParametersFunction().apply((Event)flowExecutionResponse);
            Message message = this.getParametersTransformer().map(parametersTransformer -> parametersTransformer.fromSuccessResponseParametersToMessage(this.originalResponseParameters)).orElseGet(flowExecutionResponse::getMessage);
            return Event.builder(event).message(message).build();
        }).onErrorMap(MessagingException.class, messagingException -> {
            this.originalFailureResponseParameters = ((MessageSourceResponseParametersProcessor)this.getParametersProcessor()).getFailedExecutionResponseParametersFunction().apply(messagingException.getEvent());
            Message message = this.getParametersTransformer().map(parametersTransformer -> parametersTransformer.fromFailureResponseParametersToMessage(this.originalFailureResponseParameters)).orElse(messagingException.getEvent().getMessage());
            return new FlowExecutionException(Event.builder(event).message(message).build(), messagingException.getCause(), messagingException.getFailingMessageProcessor());
        });
    }

    @Override
    protected Publisher<Event> processPolicy(Policy policy, Processor nextProcessor, Event event) {
        return Mono.just((Object)event).transform((Function)this.sourcePolicyProcessorFactory.createSourcePolicy(policy, nextProcessor));
    }

    @Override
    public Publisher<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>> process(Event sourceEvent) {
        return Mono.from(this.processPolicies(sourceEvent)).map(policiesResultEvent -> {
            Supplier<Map<String, Object>> responseParameters = () -> this.getParametersTransformer().map(parametersTransformer -> this.concatMaps(this.originalResponseParameters, parametersTransformer.fromMessageToSuccessResponseParameters(policiesResultEvent.getMessage()))).orElse(this.originalResponseParameters);
            return Either.right(new SourcePolicySuccessResult((Event)policiesResultEvent, responseParameters, (MessageSourceResponseParametersProcessor)this.getParametersProcessor()));
        }).onErrorResume(FlowExecutionException.class, e -> {
            Supplier<Map<String, Object>> responseParameters = () -> this.getParametersTransformer().map(parametersTransformer -> this.concatMaps(this.originalFailureResponseParameters, parametersTransformer.fromMessageToErrorResponseParameters(e.getEvent().getMessage()))).orElse(this.originalFailureResponseParameters);
            return Mono.just(Either.left(new SourcePolicyFailureResult((MessagingException)e, responseParameters)));
        }).onErrorResume(MessagingException.class, e -> {
            Supplier<Map<String, Object>> responseParameters = () -> this.getParametersTransformer().map(parametersTransformer -> this.concatMaps(this.originalFailureResponseParameters, parametersTransformer.fromMessageToErrorResponseParameters(Message.of(null)))).orElse(this.originalFailureResponseParameters);
            return Mono.just(Either.left(new SourcePolicyFailureResult((MessagingException)e, responseParameters)));
        });
    }

    private Map<String, Object> concatMaps(Map<String, Object> originalResponseParameters, Map<String, Object> policyResponseParameters) {
        HashMap<String, Object> concatMap = new HashMap<String, Object>();
        if (originalResponseParameters != null) {
            concatMap.putAll(originalResponseParameters);
        }
        concatMap.putAll(policyResponseParameters);
        return concatMap;
    }
}

