/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.PolicyEventConverter;
import org.mule.runtime.core.policy.PolicyStateHandler;
import org.mule.runtime.core.policy.PolicyStateId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class OperationPolicyProcessor
implements Processor {
    private final Policy policy;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();
    private final Processor nextProcessor;

    public OperationPolicyProcessor(Policy policy, PolicyStateHandler policyStateHandler, Processor nextProcessor) {
        this.policy = policy;
        this.policyStateHandler = policyStateHandler;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public Event process(Event operationEvent) throws MuleException {
        return MessageProcessors.processToApply(operationEvent, this);
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Mono.from(publisher).then(operationEvent -> {
            PolicyStateId policyStateId = new PolicyStateId(operationEvent.getContext().getCorrelationId(), this.policy.getPolicyId());
            Optional<Event> latestPolicyState = this.policyStateHandler.getLatestState(policyStateId);
            Event variablesProviderEvent = latestPolicyState.orElseGet(() -> Event.builder(operationEvent.getContext()).message(Message.of(null)).build());
            this.policyStateHandler.updateState(policyStateId, variablesProviderEvent);
            Event policyEvent = this.policyEventConverter.createEvent((Event)operationEvent, variablesProviderEvent);
            Processor operationCall = this.buildOperationExecutionWithPolicyFunction(this.nextProcessor, (Event)operationEvent);
            this.policyStateHandler.updateNextOperation(policyStateId.getExecutionIndentifier(), operationCall);
            return this.executePolicyChain((Event)operationEvent, policyStateId, policyEvent);
        });
    }

    private Mono<Event> executePolicyChain(Event operationEvent, PolicyStateId policyStateId, Event policyEvent) {
        return Mono.just((Object)policyEvent).transform((Function)this.policy.getPolicyChain()).doOnNext(policyChainResult -> this.policyStateHandler.updateState(policyStateId, (Event)policyChainResult)).map(policyChainResult -> this.policyEventConverter.createEvent((Event)policyChainResult, operationEvent));
    }

    private Processor buildOperationExecutionWithPolicyFunction(final Processor nextOperation, final Event operationEvent) {
        return new Processor(){

            @Override
            public Event process(Event event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<Event> apply(Publisher<Event> publisher) {
                return Mono.from(publisher).then(policyExecuteNextEvent -> {
                    PolicyStateId policyStateId = new PolicyStateId(policyExecuteNextEvent.getContext().getId(), OperationPolicyProcessor.this.policy.getPolicyId());
                    OperationPolicyProcessor.this.policyStateHandler.updateState(policyStateId, (Event)policyExecuteNextEvent);
                    return Mono.just((Object)policyExecuteNextEvent).map(event -> OperationPolicyProcessor.this.policyEventConverter.createEvent((Event)event, operationEvent)).transform((Function)nextOperation).map(operationResult -> OperationPolicyProcessor.this.policyEventConverter.createEvent((Event)operationResult, (Event)policyExecuteNextEvent));
                });
            }
        };
    }
}

