/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PolicyChain
extends AbstractAnnotatedObject
implements Initialisable,
Startable,
FlowConstructAware,
Stoppable,
Disposable,
Processor {
    @Inject
    private MuleContext muleContext;
    private List<Processor> processors;
    private MessageProcessorChain processorChain;
    private FlowConstruct flowConstruct;

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    @Override
    public final void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.processors, this.muleContext, this.flowConstruct);
        this.processorChain = new DefaultMessageProcessorChainBuilder().chain(this.processors).build();
        this.processorChain.setMuleContext(this.muleContext);
        this.processorChain.setFlowConstruct(this.flowConstruct);
        this.processorChain.initialise();
    }

    @Override
    public void start() throws MuleException {
        this.processorChain.start();
    }

    @Override
    public void dispose() {
        this.processorChain.dispose();
    }

    @Override
    public void stop() throws MuleException {
        this.processorChain.stop();
    }

    @Override
    public Event process(Event event) throws MuleException {
        return this.processorChain.process(event);
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Mono.from(publisher).transform((Function)this.processorChain);
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

