/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.chain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.MessageProcessorNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAware;
import org.mule.runtime.core.api.execution.MessageProcessorExecutionTemplate;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.transport.LegacyInboundEndpoint;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.streaming.StreamingManager;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageProcessorChain
extends AbstractAnnotatedObject
implements MessageProcessorChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageProcessorChain.class);
    protected String name;
    protected List<Processor> processors;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private MessageProcessorExecutionTemplate messageProcessorExecutionTemplate = MessageProcessorExecutionTemplate.createExecutionTemplate();
    protected MessagingExceptionHandler messagingExceptionHandler;
    private StreamingManager streamingManager;

    public AbstractMessageProcessorChain(List<Processor> processors) {
        this(null, processors);
    }

    public AbstractMessageProcessorChain(String name, List<Processor> processors) {
        this.name = name;
        this.processors = processors;
    }

    @Override
    public Event process(Event event) throws MuleException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Invoking %s with event %s", this, event));
        }
        if (event == null) {
            return null;
        }
        return this.doProcess(event);
    }

    protected Event doProcess(Event event) throws MuleException {
        for (Processor processor : this.getProcessorsToExecute()) {
            Event.setCurrentEvent(event);
            if ((event = this.messageProcessorExecutionTemplate.execute(processor, event)) != null) continue;
            return null;
        }
        return event;
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptors = this.resolveInterceptors();
        Flux stream = Flux.from(publisher);
        for (Processor processor : this.getProcessorsToExecute()) {
            stream = stream.transform((Function)this.applyInterceptors(interceptors, processor));
        }
        return stream;
    }

    private ReactiveProcessor applyInterceptors(List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptorsToBeExecuted, Processor processor) {
        ReactiveProcessor interceptorWrapperProcessorFunction = processor;
        for (BiFunction<Processor, ReactiveProcessor, ReactiveProcessor> interceptor : interceptorsToBeExecuted) {
            interceptorWrapperProcessorFunction = interceptor.apply(processor, interceptorWrapperProcessorFunction);
        }
        return interceptorWrapperProcessorFunction;
    }

    private List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> resolveInterceptors() {
        ArrayList<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptors = new ArrayList<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>>();
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).onErrorMap(MessagingException.class, this.updateMessagingException((Processor)processor)));
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).doOnNext(event -> Event.setCurrentEvent(event)).transform((Function)next));
        if (this.flowConstruct instanceof Pipeline) {
            interceptors.add((processor, next) -> ((Pipeline)this.flowConstruct).getProcessingStrategy().onProcessor(new ReactiveProcessor((ReactiveProcessor)next, (Processor)processor){
                final /* synthetic */ ReactiveProcessor val$next;
                final /* synthetic */ Processor val$processor;
                {
                    this.val$next = reactiveProcessor;
                    this.val$processor = processor;
                }

                @Override
                public Publisher<Event> apply(Publisher<Event> eventPublisher) {
                    return (Publisher)this.val$next.apply(eventPublisher);
                }

                @Override
                public ReactiveProcessor.ProcessingType getProcessingType() {
                    return this.val$processor.getProcessingType();
                }
            }));
        }
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).doOnNext(result -> Event.setCurrentEvent(result)));
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).doOnNext(this.preNotification((Processor)processor)).transform((Function)next).doOnNext(this.postNotification((Processor)processor)).doOnError(MessagingException.class, this.errorNotification((Processor)processor)));
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).map(result -> {
            Object payload = result.getMessage().getPayload().getValue();
            if (payload instanceof CursorProvider) {
                Message message = Message.builder(result.getMessage()).payload(this.streamingManager.manage((CursorProvider)payload, (Event)result)).build();
                result = Event.builder(result).message(message).build();
            }
            return result;
        }));
        this.muleContext.getProcessorInterceptorManager().getInterceptorFactories().stream().forEach(interceptorFactory -> {
            ReactiveInterceptorAdapter reactiveInterceptorAdapter = new ReactiveInterceptorAdapter((ProcessorInterceptorFactory)interceptorFactory);
            reactiveInterceptorAdapter.setFlowConstruct(this.flowConstruct);
            interceptors.add(0, reactiveInterceptorAdapter);
        });
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).concatMap(event -> Flux.just((Object)event).transform((Function)next).onErrorResume(RejectedExecutionException.class, throwable -> this.handleError(event.getContext()).apply(ExceptionUtils.updateMessagingExceptionWithError(new MessagingException((Event)event, (Throwable)throwable, (Processor)processor), processor, this.flowConstruct))).onErrorResume(MessagingException.class, this.handleError(event.getContext()))));
        return interceptors;
    }

    private Function<MessagingException, MessagingException> updateMessagingException(Processor processor) {
        return exception -> ExceptionUtils.updateMessagingException(LOGGER, processor, exception, this.muleContext.getErrorTypeLocator(), this.muleContext.getErrorTypeRepository(), this.flowConstruct, this.muleContext);
    }

    private Function<MessagingException, Publisher<Event>> handleError(EventContext eventContext) {
        if (this.flowConstruct instanceof Pipeline && ((Pipeline)this.flowConstruct).getSource() instanceof LegacyInboundEndpoint) {
            return messagingException -> {
                eventContext.error((Throwable)messagingException);
                return Mono.empty();
            };
        }
        return messagingException -> Mono.from(this.getMessagingExceptionHandler().apply((MessagingException)messagingException)).flatMapMany(handled -> {
            eventContext.success((Event)handled);
            return Mono.empty();
        }).onErrorResume(rethrown -> {
            eventContext.error((Throwable)rethrown);
            return Mono.empty();
        });
    }

    private Consumer<Event> preNotification(Processor processor) {
        return event -> {
            if (event.isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), this.flowConstruct, (Event)event, processor, null, 1601);
            }
        };
    }

    private Consumer<Event> postNotification(Processor processor) {
        return event -> {
            if (event.isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), this.flowConstruct, (Event)event, processor, null, 1602);
            }
        };
    }

    private Consumer<MessagingException> errorNotification(Processor processor) {
        return exception -> {
            if (exception.getEvent().isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), this.flowConstruct, exception.getEvent(), processor, (MessagingException)exception, 1602);
            }
        };
    }

    private void fireNotification(ServerNotificationManager serverNotificationManager, FlowConstruct flowConstruct, Event event, Processor processor, MessagingException exceptionThrown, int action) {
        if (serverNotificationManager != null && serverNotificationManager.isNotificationEnabled(MessageProcessorNotification.class) && processor instanceof AnnotatedObject && ((AnnotatedObject)((Object)processor)).getLocation() != null) {
            serverNotificationManager.fireNotification(MessageProcessorNotification.createFrom(event, flowConstruct, processor, exceptionThrown, action));
        }
    }

    protected List<Processor> getProcessorsToExecute() {
        return this.processors;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.getClass().getSimpleName());
        if (!org.mule.runtime.core.api.util.StringUtils.isBlank(this.name)) {
            string.append(String.format(" '%s' ", this.name));
        }
        Iterator<Processor> mpIterator = this.processors.iterator();
        String nl = String.format("%n", new Object[0]);
        if (mpIterator.hasNext()) {
            string.append(String.format("%n[ ", new Object[0]));
            while (mpIterator.hasNext()) {
                Processor mp = mpIterator.next();
                String indented = StringUtils.replace((String)mp.toString(), (String)nl, (String)String.format("%n  ", new Object[0]));
                string.append(String.format("%n  %s", indented));
                if (!mpIterator.hasNext()) continue;
                string.append(", ");
            }
            string.append(String.format("%n]", new Object[0]));
        }
        return string.toString();
    }

    @Override
    public List<Processor> getMessageProcessors() {
        return this.processors;
    }

    protected List<Processor> getMessageProcessorsForLifecycle() {
        return this.processors;
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        this.messagingExceptionHandler = messagingExceptionHandler;
        for (Processor processor : this.processors) {
            if (!(processor instanceof MessagingExceptionHandlerAware)) continue;
            ((MessagingExceptionHandlerAware)((Object)processor)).setMessagingExceptionHandler(messagingExceptionHandler);
        }
    }

    public MessagingExceptionHandler getMessagingExceptionHandler() {
        return this.messagingExceptionHandler != null ? this.messagingExceptionHandler : this.flowConstruct.getExceptionListener();
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.messageProcessorExecutionTemplate.setMuleContext(muleContext);
        LifecycleUtils.setMuleContextIfNeeded(this.getMessageProcessorsForLifecycle(), muleContext);
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        this.messageProcessorExecutionTemplate.setFlowConstruct(flowConstruct);
        LifecycleUtils.setFlowConstructIfNeeded(this.getMessageProcessorsForLifecycle(), flowConstruct);
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.streamingManager = this.muleContext.getRegistry().lookupObject(StreamingManager.class);
        }
        catch (RegistrationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded(this.getMessageProcessorsForLifecycle(), true, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        ArrayList<Processor> startedProcessors = new ArrayList<Processor>();
        try {
            for (Processor processor : this.getMessageProcessorsForLifecycle()) {
                if (!(processor instanceof Startable)) continue;
                ((Startable)((Object)processor)).start();
                startedProcessors.add(processor);
            }
        }
        catch (MuleException e) {
            LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
            throw e;
        }
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.getMessageProcessorsForLifecycle(), LOGGER);
    }
}

