/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.processor.strategy.DirectSink;
import reactor.core.publisher.BlockingSink;

public abstract class AbstractProcessingStrategy
implements ProcessingStrategy {
    public static final String TRANSACTIONAL_ERROR_MESSAGE = "Unable to process a transactional flow asynchronously";

    @Override
    public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
        return new DirectSink(pipeline, this.createOnEventConsumer());
    }

    protected Consumer<Event> createOnEventConsumer() {
        return event -> {
            if (TransactionCoordination.isTransactionActive()) {
                event.getContext().error(new MessagingException((Event)event, (Throwable)new DefaultMuleException(I18nMessageFactory.createStaticMessage(TRANSACTIONAL_ERROR_MESSAGE))));
            }
        };
    }

    protected ExecutorService decorateScheduler(Scheduler scheduler) {
        return scheduler;
    }

    static final class ReactorSink
    implements Sink,
    Disposable {
        private final BlockingSink<Event> blockingSink;
        private final reactor.core.Disposable disposable;
        private final Consumer onEventConsumer;

        ReactorSink(BlockingSink<Event> blockingSink, reactor.core.Disposable disposable, Consumer<Event> onEventConsumer) {
            this.blockingSink = blockingSink;
            this.disposable = disposable;
            this.onEventConsumer = onEventConsumer;
        }

        @Override
        public void accept(Event event) {
            this.onEventConsumer.accept(event);
            this.blockingSink.accept((Object)event);
        }

        @Override
        public void dispose() {
            this.blockingSink.complete();
            this.disposable.dispose();
        }
    }
}

