/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.strategy;

import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;

public abstract class AbstractProcessingStrategyFactory
implements AsyncProcessingStrategyFactory {
    private int maxConcurrency = Integer.MAX_VALUE;

    @Override
    public void setMaxConcurrency(int maxConcurrency) {
        if (maxConcurrency < 1) {
            throw new IllegalArgumentException("maxConcurrency must be at least 1");
        }
        this.maxConcurrency = maxConcurrency;
    }

    protected int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    protected SchedulerConfig createSchedulerConfig(MuleContext muleContext, String schedulersNamePrefix, ReactiveProcessor.ProcessingType processingType) {
        SchedulerConfig schedulerConfig = muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + processingType.name());
        if (this.getMaxConcurrency() != Integer.MAX_VALUE) {
            schedulerConfig = schedulerConfig.withMaxConcurrentTasks(this.getMaxConcurrency());
        }
        return schedulerConfig;
    }
}

