/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.strategy;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.processor.strategy.AbstractProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.StreamPerEventSink;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class ReactorProcessingStrategyFactory
extends AbstractProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new ReactorProcessingStrategy(() -> muleContext.getSchedulerService().cpuLightScheduler(this.createSchedulerConfig(muleContext, schedulersNamePrefix, ReactiveProcessor.ProcessingType.CPU_LITE)));
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return ReactorProcessingStrategy.class;
    }

    static class ReactorProcessingStrategy
    extends AbstractProcessingStrategy
    implements Startable,
    Stoppable {
        private final Supplier<Scheduler> cpuLightSchedulerSupplier;
        private Scheduler cpuLightScheduler;

        public ReactorProcessingStrategy(Supplier<Scheduler> cpuLightSchedulerSupplier) {
            this.cpuLightSchedulerSupplier = Objects.requireNonNull(cpuLightSchedulerSupplier);
        }

        @Override
        public void start() throws MuleException {
            this.cpuLightScheduler = this.cpuLightSchedulerSupplier.get();
        }

        @Override
        public void stop() throws MuleException {
            if (this.cpuLightScheduler != null) {
                this.cpuLightScheduler.stop();
            }
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            return new StreamPerEventSink(pipeline, this.createOnEventConsumer());
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            return publisher -> Flux.from((Publisher)publisher).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.cpuLightScheduler))).transform((Function)pipeline);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
                return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.cpuLightScheduler)));
            }
            return super.onProcessor(processor);
        }

        protected Scheduler getCpuLightScheduler() {
            return this.cpuLightScheduler;
        }
    }
}

