/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class ReactorStreamProcessingStrategyFactory
extends AbstractStreamProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new ReactorStreamProcessingStrategy(() -> muleContext.getSchedulerService().customScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + RING_BUFFER_SCHEDULER_NAME_SUFFIX).withMaxConcurrentTasks(this.getSubscriberCount() + 1).withWaitAllowed(true)), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), () -> muleContext.getSchedulerService().cpuLightScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name())), this.getMaxConcurrency());
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return ReactorStreamProcessingStrategy.class;
    }

    static class ReactorStreamProcessingStrategy
    extends AbstractStreamProcessingStrategyFactory.AbstractStreamProcessingStrategy
    implements Startable,
    Stoppable {
        private Supplier<Scheduler> cpuLightSchedulerSupplier;
        private Scheduler cpuLightScheduler;

        ReactorStreamProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscribers, String waitStrategy, Supplier<Scheduler> cpuLightSchedulerSupplier, int maxConcurrency) {
            super(ringBufferSchedulerSupplier, bufferSize, subscribers, waitStrategy, maxConcurrency);
            this.cpuLightSchedulerSupplier = cpuLightSchedulerSupplier;
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            if (this.maxConcurrency > this.subscribers) {
                return publisher -> Flux.from((Publisher)publisher).parallel(this.getNumCpuLightThreads()).runOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.getCpuLightScheduler()))).composeGroup((Function)pipeline);
            }
            return super.onPipeline(pipeline);
        }

        private int getNumCpuLightThreads() {
            return Math.min(Runtime.getRuntime().availableProcessors() * 2, this.maxConcurrency);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
                return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).parallel(this.getNumCpuLightThreads()).runOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.getCpuLightScheduler())));
            }
            return super.onProcessor(processor);
        }

        @Override
        public void start() throws MuleException {
            this.cpuLightScheduler = this.cpuLightSchedulerSupplier.get();
        }

        @Override
        public void stop() throws MuleException {
            if (this.cpuLightScheduler != null) {
                this.cpuLightScheduler.stop();
            }
        }

        protected Scheduler getCpuLightScheduler() {
            return this.cpuLightScheduler;
        }
    }
}

