/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.routing.RouterResultsHandler;

public class DefaultRouterResultsHandler
implements RouterResultsHandler {
    private boolean returnCollectionWithSingleResult = false;

    public DefaultRouterResultsHandler() {
    }

    public DefaultRouterResultsHandler(boolean returnCollectionWithSingleResult) {
        this.returnCollectionWithSingleResult = returnCollectionWithSingleResult;
    }

    @Override
    public Event aggregateResults(List<Event> results, Event previous) {
        if (results == null) {
            return null;
        }
        if (results.size() == 1) {
            Event event = results.get(0);
            if (event == null) {
                return event;
            }
            if (event != null && event.getMessage() != null) {
                if (this.returnCollectionWithSingleResult) {
                    return this.createMessageCollectionWithSingleMessage(event);
                }
                return event;
            }
            return previous;
        }
        List<Event> nonNullResults = results.stream().filter(object -> object != null && object.getMessage() != null).collect(Collectors.toList());
        if (nonNullResults.size() == 0) {
            return Event.builder(previous).message(Message.of(null)).build();
        }
        if (nonNullResults.size() == 1) {
            return (Event)nonNullResults.get(0);
        }
        return this.createMessageCollection(nonNullResults, previous);
    }

    private Event createMessageCollectionWithSingleMessage(Event event) {
        Message coll = Message.builder().collectionPayload(Collections.singletonList(event.getMessage()), Message.class).build();
        event = Event.builder(event).message(coll).build();
        Event.setCurrentEvent(event);
        return event;
    }

    private Event createMessageCollection(List<Event> nonNullResults, Event previous) {
        Event.Builder resultBuilder = Event.builder(previous);
        ArrayList<Message> list = new ArrayList<Message>();
        for (Event event : nonNullResults) {
            for (String flowVarName : event.getVariableNames()) {
                resultBuilder.addVariable(flowVarName, event.getVariable(flowVarName).getValue(), event.getVariable(flowVarName).getDataType());
            }
            list.add(event.getMessage());
        }
        Message coll = Message.builder().collectionPayload(list, Message.class).build();
        Event resultEvent = resultBuilder.message(coll).build();
        Event.setCurrentEvent(resultEvent);
        return resultEvent;
    }
}

