/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.routing.AbstractRoutingStrategy;
import org.mule.runtime.core.routing.RoutingFailedException;

public class FirstSuccessfulRoutingStrategy
extends AbstractRoutingStrategy {
    private FlowConstruct flowConstruct;
    private String failureExpression;
    private RouteProcessor processor;

    public FirstSuccessfulRoutingStrategy(FlowConstruct flowConstruct, String failureExpression, RouteProcessor processor) {
        super(flowConstruct.getMuleContext());
        this.flowConstruct = flowConstruct;
        this.failureExpression = failureExpression;
        this.processor = processor;
    }

    @Override
    public Event route(Event event, List<Processor> messageProcessors) throws MuleException {
        Event returnEvent = null;
        boolean failed = true;
        Exception failExceptionCause = null;
        FirstSuccessfulRoutingStrategy.validateMessageIsNotConsumable(event.getMessage());
        for (Processor mp : messageProcessors) {
            try {
                returnEvent = this.processor.processRoute(mp, event);
                failed = returnEvent == null ? false : (returnEvent.getMessage() == null ? true : this.getMuleContext().getExpressionManager().evaluateBoolean(this.failureExpression, returnEvent, this.flowConstruct, false, true));
            }
            catch (Exception ex) {
                failed = true;
                failExceptionCause = ex;
            }
            if (failed) continue;
            break;
        }
        if (failed) {
            if (failExceptionCause != null) {
                throw new RoutingFailedException(I18nMessageFactory.createStaticMessage("all message processor failed during first successful routing strategy"), failExceptionCause);
            }
            throw new RoutingFailedException(I18nMessageFactory.createStaticMessage("all message processor failed during first successful routing strategy"));
        }
        return returnEvent;
    }

    static interface RouteProcessor {
        public Event processRoute(Processor var1, Event var2) throws MuleException;
    }
}

