/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.execution.LocationExecutionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.routing.filter.FilterUnacceptedException;
import org.mule.runtime.core.processor.AbstractFilteringMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFilter
extends AbstractFilteringMessageProcessor
implements FlowConstructAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFilter.class);
    protected Filter filter;

    @Deprecated
    public MessageFilter() {
    }

    public MessageFilter(Filter filter) {
        this.filter = filter;
    }

    public MessageFilter(Filter filter, boolean throwExceptionOnUnaccepted, Processor messageProcessor) {
        this.filter = filter;
        this.throwOnUnaccepted = throwExceptionOnUnaccepted;
        this.unacceptedMessageProcessor = messageProcessor;
        this.setUnacceptedMessageProcessor(this.unacceptedMessageProcessor);
    }

    @Override
    protected boolean accept(Event event, Event.Builder builder) {
        if (this.filter == null) {
            return true;
        }
        if (event != null) {
            return this.filter.accept(event, builder);
        }
        return false;
    }

    @Override
    protected MessagingException filterFailureException(Event event, Exception ex) {
        MessagingException messagingException = new MessagingException(event, ex, (Processor)this);
        String docName = LocationExecutionContextProvider.getDocName(this.filter);
        messagingException.getInfo().put("Filter", docName != null ? String.format("%s (%s)", this.filter.toString(), docName) : this.filter.toString());
        return messagingException;
    }

    @Override
    protected MuleException filterUnacceptedException(Event event) {
        return new FilterUnacceptedException(CoreMessages.messageRejectedByFilter(), this.filter);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public String toString() {
        return (this.filter == null ? "null filter" : this.filter.getClass().getName()) + " (wrapped by " + this.getClass().getSimpleName() + ")";
    }

    @Override
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.unacceptedMessageProcessor)).setMuleContext(context);
        }
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)this.unacceptedMessageProcessor)).setFlowConstruct(flowConstruct);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof Initialisable) {
            ((Initialisable)((Object)this.unacceptedMessageProcessor)).initialise();
        }
        LifecycleUtils.initialiseIfNeeded(this.filter);
    }

    @Override
    public void start() throws MuleException {
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof Startable) {
            ((Startable)((Object)this.unacceptedMessageProcessor)).start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof Stoppable) {
            ((Stoppable)((Object)this.unacceptedMessageProcessor)).stop();
        }
    }

    @Override
    public void dispose() {
        if (!this.onUnacceptedFlowConstruct && this.unacceptedMessageProcessor instanceof Disposable) {
            ((Disposable)((Object)this.unacceptedMessageProcessor)).dispose();
        }
        LifecycleUtils.disposeIfNeeded(this.filter, LOGGER);
    }
}

