/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.Comparator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.routing.AbstractAggregator;
import org.mule.runtime.core.routing.correlation.CorrelationSequenceComparator;
import org.mule.runtime.core.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.routing.correlation.ResequenceMessagesCorrelatorCallback;

public class Resequencer
extends AbstractAggregator {
    protected Comparator eventComparator;

    public Resequencer() {
        this.setEventComparator(new CorrelationSequenceComparator());
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.eventComparator == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("eventComparator"), (Initialisable)this);
        }
        super.initialise();
    }

    public Comparator getEventComparator() {
        return this.eventComparator;
    }

    public void setEventComparator(Comparator eventComparator) {
        this.eventComparator = eventComparator;
    }

    @Override
    protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
        return new ResequenceMessagesCorrelatorCallback(this.getEventComparator(), muleContext, this.storePrefix);
    }

    @Override
    public Event process(Event event) throws MuleException {
        Event result = this.eventCorrelator.process(event);
        if (!this.isEventValid(result)) {
            return result;
        }
        Event last = null;
        for (Event muleEvent : (Event[])result.getMessage().getPayload().getValue()) {
            last = this.processNext(muleEvent);
        }
        return last;
    }
}

