/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.filters;

import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.routing.filter.ObjectFilter;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildcardFilter
implements Filter,
ObjectFilter,
MuleContextAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected volatile String pattern;
    protected volatile String[] patterns;
    private volatile boolean caseSensitive = true;
    private MuleContext muleContext;

    public WildcardFilter() {
    }

    public WildcardFilter(String pattern) {
        this.setPattern(pattern);
    }

    @Override
    public boolean accept(Message message, Event.Builder builder) {
        try {
            return this.accept(this.muleContext.getTransformationService().internalTransform(message, DataType.STRING).getPayload().getValue());
        }
        catch (Exception e) {
            this.logger.warn("An exception occurred while filtering", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean accept(Object object) {
        if (object == null || this.pattern == null) {
            return false;
        }
        if (this.pattern.equals(object)) {
            return true;
        }
        String[] currentPatterns = this.patterns;
        if (currentPatterns != null) {
            for (String pattern : currentPatterns) {
                int i2;
                int i;
                boolean foundMatch;
                if ("*".equals(pattern) || "**".equals(pattern)) {
                    return true;
                }
                String candidate = object.toString();
                if (!this.isCaseSensitive()) {
                    pattern = pattern.toLowerCase();
                    candidate = candidate.toLowerCase();
                }
                if (foundMatch = (i = pattern.indexOf(42)) == -1 ? pattern.equals(candidate) : ((i2 = pattern.indexOf(42, i + 1)) > 1 ? candidate.indexOf(pattern.substring(1, i2)) > -1 : (i == 0 ? candidate.endsWith(pattern.substring(1)) : candidate.startsWith(pattern.substring(0, i))))) {
                    return true;
                }
                if (!pattern.endsWith("+") || pattern.length() <= 1) continue;
                this.logger.warn("wildcard-filter for payload based filtering is deprecated. Use expression-filter or payload-type-filter instead");
                return this.filterByClassName(object, pattern);
            }
        }
        return false;
    }

    @Deprecated
    private boolean filterByClassName(Object object, String pattern) {
        String className = pattern.substring(0, pattern.length() - 1);
        try {
            Class theClass = ClassUtils.loadClass(className, this.getClass());
            if (!(object instanceof String) ? theClass.isInstance(object) : theClass.isAssignableFrom(ClassUtils.loadClass(object.toString(), this.getClass()))) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.patterns = StringUtils.splitAndTrim(pattern, ",");
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardFilter other = (WildcardFilter)obj;
        return ClassUtils.equal(this.pattern, other.pattern) && ClassUtils.equal(this.patterns, other.patterns) && this.caseSensitive == other.caseSensitive;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.pattern, this.patterns, this.caseSensitive});
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

