/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.util.Base64;
import org.mule.runtime.core.security.AbstractNamedEncryptionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJCEEncryptionStrategy
extends AbstractNamedEncryptionStrategy {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected KeySpec keySpec;
    protected SecretKey secretKey;
    protected Cipher encryptCipher;
    protected Cipher decryptCipher;
    protected String algorithm = null;
    protected boolean base64Encoding = true;

    @Override
    public void initialise() throws InitialisationException {
        if (this.algorithm == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("Algorithm"), (Initialisable)this);
        }
        this.logger.debug("Using encryption algorithm: " + this.algorithm);
        this.keySpec = this.createKeySpec();
        try {
            this.secretKey = this.getSecretKey();
            this.createAndInitCiphers();
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToCreate("encryption ciphers"), (Throwable)e, this);
        }
    }

    protected void createAndInitCiphers() throws GeneralSecurityException {
        this.encryptCipher = Cipher.getInstance(this.getAlgorithm());
        this.decryptCipher = Cipher.getInstance(this.getAlgorithm());
        AlgorithmParameterSpec paramSpec = this.createAlgorithmParameterSpec();
        if (paramSpec != null) {
            this.encryptCipher.init(1, (Key)this.secretKey, paramSpec);
            this.decryptCipher.init(2, (Key)this.secretKey, paramSpec);
        } else {
            this.encryptCipher.init(1, this.secretKey);
            this.decryptCipher.init(2, this.secretKey);
        }
    }

    protected abstract SecretKey getSecretKey() throws GeneralSecurityException;

    @Override
    public InputStream encrypt(InputStream data, Object info) throws CryptoFailureException {
        try {
            return new ByteArrayInputStream(this.encrypt(IOUtils.toByteArray((InputStream)data), info));
        }
        catch (IOException e) {
            throw new CryptoFailureException(this, (Throwable)e);
        }
    }

    @Override
    public InputStream decrypt(InputStream data, Object info) throws CryptoFailureException {
        try {
            return new ByteArrayInputStream(this.decrypt(IOUtils.toByteArray((InputStream)data), info));
        }
        catch (IOException e) {
            throw new CryptoFailureException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] encrypt(byte[] data, Object info) throws CryptoFailureException {
        try {
            byte[] buf = this.encryptCipher.doFinal(data);
            if (this.base64Encoding) {
                return Base64.encodeBytes(buf).getBytes();
            }
            return buf;
        }
        catch (Exception e) {
            throw new CryptoFailureException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data, Object info) throws CryptoFailureException {
        try {
            byte[] dec = data;
            if (this.base64Encoding) {
                dec = Base64.decode(new String(data));
            }
            return this.decryptCipher.doFinal(dec);
        }
        catch (Exception e) {
            throw new CryptoFailureException(this, (Throwable)e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Algorithm=").append(this.algorithm);
        return buf.toString();
    }

    public boolean isBase64Encoding() {
        return this.base64Encoding;
    }

    public void setBase64Encoding(boolean base64Encoding) {
        this.base64Encoding = base64Encoding;
    }

    protected abstract KeySpec createKeySpec();

    protected abstract AlgorithmParameterSpec createAlgorithmParameterSpec();
}

