/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractMessageTransformer;

public class TransformerChain
extends AbstractMessageTransformer {
    private List<Transformer> transformers;

    public TransformerChain(List<Transformer> transformers) {
        if (transformers.size() < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = new LinkedList<Transformer>(transformers);
    }

    public TransformerChain(Transformer ... transformers) {
        this(Arrays.asList(transformers));
        this.name = this.generateTransformerName();
        this.setReturnDataType(transformers[transformers.length - 1].getReturnDataType());
    }

    public TransformerChain(String name, List<Transformer> transformers) {
        this(transformers);
        this.name = name;
    }

    public TransformerChain(String name, Transformer ... transformers) {
        this(name, Arrays.asList(transformers));
    }

    @Override
    public Object transformMessage(Event event, Charset outputEncoding) throws TransformerException {
        Message result = event.getMessage();
        Object temp = event.getMessage();
        Transformer lastTransformer = null;
        for (Transformer element : this.transformers) {
            lastTransformer = element;
            temp = lastTransformer.transform(temp);
            if (temp instanceof Message) {
                result = (Message)temp;
                continue;
            }
            result = Message.builder(event.getMessage()).payload(temp).build();
            event = Event.builder(event).message(result).build();
        }
        if (lastTransformer != null && Message.class.isAssignableFrom(lastTransformer.getReturnDataType().getType())) {
            return result;
        }
        return result.getPayload().getValue();
    }

    @Override
    public void initialise() throws InitialisationException {
        for (Transformer transformer : this.transformers) {
            transformer.initialise();
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        for (Transformer transformer : this.transformers) {
            transformer.setMuleContext(muleContext);
        }
    }

    @Override
    protected String generateTransformerName() {
        String name = this.transformers.get(0).getClass().getSimpleName();
        int i = name.indexOf("To");
        DataType dt = this.transformers.get(this.transformers.size() - 1).getReturnDataType();
        if (i > 0 && dt != null) {
            String target = dt.getType().getSimpleName();
            if (target.equals("byte[]")) {
                target = "byteArray";
            }
            name = name.substring(0, i + 2) + StringUtils.capitalize((String)target);
        }
        return name;
    }

    public List<Transformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }
}

