/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.api.plugin;

import java.util.HashMap;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ChildOnlyLookupStrategy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;

public class ArtifactPluginClassLoaderFactory
implements ArtifactClassLoaderFactory<ArtifactPluginDescriptor> {
    private final ModuleRepository moduleRepository;

    public ArtifactPluginClassLoaderFactory(ModuleRepository moduleRepository) {
        Preconditions.checkArgument(moduleRepository != null, "moduleRepository cannot be null");
        this.moduleRepository = moduleRepository;
    }

    @Override
    public ArtifactClassLoader create(String artifactId, ArtifactPluginDescriptor descriptor, ClassLoader parent, ClassLoaderLookupPolicy baseLookupPolicy) {
        HashMap<String, LookupStrategy> pluginsLookupPolicies = new HashMap<String, LookupStrategy>();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : descriptor.getArtifactPluginDescriptors()) {
            if (artifactPluginDescriptor.getName().equals(descriptor.getName())) continue;
            LookupStrategy parentFirst = this.getClassLoaderLookupStrategy(descriptor, artifactPluginDescriptor);
            for (String exportedPackage : artifactPluginDescriptor.getClassLoaderModel().getExportedPackages()) {
                pluginsLookupPolicies.put(exportedPackage, parentFirst);
            }
        }
        ContainerOnlyLookupStrategy containerOnlyLookupStrategy = new ContainerOnlyLookupStrategy(this.getClass().getClassLoader());
        for (MuleModule module : this.moduleRepository.getModules()) {
            if (!module.getPrivilegedArtifacts().contains(descriptor.getBundleDescriptor().getArtifactId())) continue;
            for (String packageName : module.getPrivilegedExportedPackages()) {
                pluginsLookupPolicies.put(packageName, containerOnlyLookupStrategy);
            }
        }
        ClassLoaderLookupPolicy classLoaderLookupPolicy = baseLookupPolicy.extend(pluginsLookupPolicies);
        return new MuleArtifactClassLoader(artifactId, descriptor, descriptor.getClassLoaderModel().getUrls(), parent, classLoaderLookupPolicy);
    }

    private LookupStrategy getClassLoaderLookupStrategy(ArtifactPluginDescriptor descriptor, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        LookupStrategy parentFirst = this.isDependencyPlugin(descriptor.getClassLoaderModel().getDependencies(), dependencyPluginDescriptor) ? ParentFirstLookupStrategy.PARENT_FIRST : ChildOnlyLookupStrategy.CHILD_ONLY;
        return parentFirst;
    }

    private boolean isDependencyPlugin(Set<BundleDependency> pluginDependencies, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        for (BundleDependency pluginDependency : pluginDependencies) {
            if (!pluginDependency.getDescriptor().getArtifactId().equals(dependencyPluginDescriptor.getBundleDescriptor().getArtifactId()) || !"mule-plugin".equals(pluginDependency.getDescriptor().getClassifier().get())) continue;
            return true;
        }
        return false;
    }
}

