/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactClassLoaderBuilder<T extends AbstractArtifactClassLoaderBuilder> {
    public static final String PLUGIN_CLASSLOADER_IDENTIFIER = "/plugin/";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ArtifactClassLoaderFactory artifactPluginClassLoaderFactory;
    private Set<ArtifactPluginDescriptor> artifactPluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
    private String artifactId = UUID.getUUID();
    protected ArtifactDescriptor artifactDescriptor;
    private ArtifactClassLoader parentClassLoader;
    protected List<ArtifactClassLoader> artifactPluginClassLoaders = new ArrayList<ArtifactClassLoader>();

    public AbstractArtifactClassLoaderBuilder(ArtifactClassLoaderFactory<ArtifactPluginDescriptor> artifactPluginClassLoaderFactory) {
        Preconditions.checkArgument(artifactPluginClassLoaderFactory != null, "artifactPluginClassLoaderFactory cannot be null");
        this.artifactPluginClassLoaderFactory = artifactPluginClassLoaderFactory;
    }

    protected abstract ArtifactClassLoader getParentClassLoader();

    public T setArtifactId(String artifactId) {
        Preconditions.checkArgument(artifactId != null, "artifact id cannot be null");
        this.artifactId = artifactId;
        return (T)this;
    }

    public T addArtifactPluginDescriptors(ArtifactPluginDescriptor ... artifactPluginDescriptors) {
        Preconditions.checkArgument(artifactPluginDescriptors != null, "artifact plugin descriptors cannot be null");
        this.artifactPluginDescriptors.addAll(Arrays.asList(artifactPluginDescriptors));
        return (T)this;
    }

    public T setArtifactDescriptor(ArtifactDescriptor artifactDescriptor) {
        this.artifactDescriptor = artifactDescriptor;
        return (T)this;
    }

    public ArtifactClassLoader build() throws IOException {
        Preconditions.checkState(this.artifactDescriptor != null, "artifact descriptor cannot be null");
        this.parentClassLoader = this.getParentClassLoader();
        Preconditions.checkState(this.parentClassLoader != null, "parent class loader cannot be null");
        String artifactId = this.getArtifactId(this.artifactDescriptor);
        ClassLoaderLookupPolicy parentLookupPolicy = this.getParentLookupPolicy(this.parentClassLoader);
        RegionClassLoader regionClassLoader = new RegionClassLoader(artifactId, this.artifactDescriptor, this.parentClassLoader.getClassLoader(), parentLookupPolicy);
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.createArtifactClassLoaderFilter(this.artifactDescriptor.getClassLoaderModel(), parentLookupPolicy);
        HashMap<String, LookupStrategy> appAdditionalLookupStrategy = new HashMap<String, LookupStrategy>();
        artifactClassLoaderFilter.getExportedClassPackages().stream().forEach(p -> appAdditionalLookupStrategy.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        List<ArtifactClassLoader> pluginClassLoaders = this.createPluginClassLoaders(artifactId, regionClassLoader, this.artifactPluginDescriptors, regionClassLoader.getClassLoaderLookupPolicy().extend(appAdditionalLookupStrategy));
        ArtifactClassLoader artifactClassLoader = this.createArtifactClassLoader(artifactId, regionClassLoader);
        regionClassLoader.addClassLoader(artifactClassLoader, artifactClassLoaderFilter);
        int artifactPluginIndex = 0;
        for (ArtifactPluginDescriptor artifactPluginDescriptor : this.artifactPluginDescriptors) {
            ArtifactClassLoaderFilter classLoaderFilter = this.createPluginClassLoaderFilter(artifactPluginDescriptor, this.artifactDescriptor.getClassLoaderModel().getExportedPackages(), parentLookupPolicy);
            regionClassLoader.addClassLoader(pluginClassLoaders.get(artifactPluginIndex), classLoaderFilter);
            ++artifactPluginIndex;
        }
        return artifactClassLoader;
    }

    protected ClassLoaderLookupPolicy getParentLookupPolicy(ArtifactClassLoader parentClassLoader) {
        return parentClassLoader.getClassLoaderLookupPolicy();
    }

    protected abstract ArtifactClassLoader createArtifactClassLoader(String var1, RegionClassLoader var2);

    private ArtifactClassLoaderFilter createArtifactClassLoaderFilter(ClassLoaderModel classLoaderModel, ClassLoaderLookupPolicy classLoaderLookupPolicy) {
        Set<String> artifactExportedPackages = this.sanitizeExportedPackages(classLoaderLookupPolicy, classLoaderModel.getExportedPackages());
        return new DefaultArtifactClassLoaderFilter(artifactExportedPackages, classLoaderModel.getExportedResources());
    }

    private ArtifactClassLoaderFilter createPluginClassLoaderFilter(ArtifactPluginDescriptor pluginDescriptor, Set<String> parentArtifactExportedPackages, ClassLoaderLookupPolicy classLoaderLookupPolicy) {
        Set<String> sanitizedArtifactExportedPackages = this.sanitizeExportedPackages(classLoaderLookupPolicy, pluginDescriptor.getClassLoaderModel().getExportedPackages());
        Set replacedPackages = parentArtifactExportedPackages.stream().filter(p -> sanitizedArtifactExportedPackages.contains(p)).collect(Collectors.toSet());
        if (!replacedPackages.isEmpty()) {
            sanitizedArtifactExportedPackages.removeAll(replacedPackages);
            this.logger.warn("Exported packages from plugin '" + pluginDescriptor.getName() + "' are provided by the artifact owner: " + replacedPackages);
        }
        return new DefaultArtifactClassLoaderFilter(sanitizedArtifactExportedPackages, pluginDescriptor.getClassLoaderModel().getExportedResources());
    }

    private Set<String> sanitizeExportedPackages(ClassLoaderLookupPolicy classLoaderLookupPolicy, Set<String> artifactExportedPackages) {
        HashSet<String> sanitizedArtifactExportedPackages = new HashSet<String>(artifactExportedPackages);
        Set containerProvidedPackages = sanitizedArtifactExportedPackages.stream().filter(p -> {
            LookupStrategy lookupStrategy = classLoaderLookupPolicy.getPackageLookupStrategy((String)p);
            return !(lookupStrategy instanceof ChildFirstLookupStrategy);
        }).collect(Collectors.toSet());
        if (!containerProvidedPackages.isEmpty()) {
            sanitizedArtifactExportedPackages.removeAll(containerProvidedPackages);
            this.logger.warn("Exported packages from artifact '" + this.artifactDescriptor.getName() + "' are provided by parent class loader: " + containerProvidedPackages);
        }
        return sanitizedArtifactExportedPackages;
    }

    protected abstract String getArtifactId(ArtifactDescriptor var1);

    private List<ArtifactClassLoader> createPluginClassLoaders(String artifactId, ArtifactClassLoader parent, Set<ArtifactPluginDescriptor> artifactPluginDescriptors, ClassLoaderLookupPolicy appExportedPackagesLookupPolicy) {
        LinkedList<ArtifactClassLoader> classLoaders = new LinkedList<ArtifactClassLoader>();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : artifactPluginDescriptors) {
            artifactPluginDescriptor.setArtifactPluginDescriptors(artifactPluginDescriptors);
            String pluginArtifactId = AbstractArtifactClassLoaderBuilder.getArtifactPluginId(artifactId, artifactPluginDescriptor.getName());
            ArtifactClassLoader artifactClassLoader = this.artifactPluginClassLoaderFactory.create(pluginArtifactId, artifactPluginDescriptor, parent.getClassLoader(), appExportedPackagesLookupPolicy);
            this.artifactPluginClassLoaders.add(artifactClassLoader);
            classLoaders.add(artifactClassLoader);
        }
        return classLoaders;
    }

    public static String getArtifactPluginId(String parentArtifactId, String pluginName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)parentArtifactId), "parentArtifactId cannot be empty");
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)pluginName), "pluginName cannot be empty");
        return parentArtifactId + PLUGIN_CLASSLOADER_IDENTIFIER + pluginName;
    }
}

