/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.parameter;

import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.extension.api.model.AbstractNamedImmutableModel;

public final class ImmutableParameterModel
extends AbstractNamedImmutableModel
implements ParameterModel {
    private final MetadataType type;
    private final boolean hasDynamicType;
    private final boolean required;
    private final boolean isConfigOverride;
    private final ValueProviderModel valueProviderModel;
    private final ExpressionSupport expressionSupport;
    private final Object defaultValue;
    private final ParameterRole role;
    private final ParameterDslConfiguration dslConfiguration;
    private final LayoutModel layoutModel;

    public ImmutableParameterModel(String name, String description, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, DisplayModel displayModel, LayoutModel layoutModel, ValueProviderModel valueProviderModel, Set<ModelProperty> modelProperties) {
        super(name, description, displayModel, modelProperties);
        this.type = type;
        this.required = required;
        this.expressionSupport = expressionSupport;
        this.defaultValue = defaultValue;
        this.role = role;
        this.hasDynamicType = hasDynamicType;
        this.dslConfiguration = dslConfiguration;
        this.layoutModel = layoutModel;
        this.isConfigOverride = isConfigOverride;
        this.valueProviderModel = valueProviderModel;
    }

    @Override
    public MetadataType getType() {
        return this.type;
    }

    @Override
    public boolean hasDynamicType() {
        return this.hasDynamicType;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isOverrideFromConfig() {
        return this.isConfigOverride;
    }

    @Override
    public ExpressionSupport getExpressionSupport() {
        return this.expressionSupport;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public ParameterDslConfiguration getDslConfiguration() {
        return this.dslConfiguration;
    }

    @Override
    public ParameterRole getRole() {
        return this.role;
    }

    @Override
    public Optional<LayoutModel> getLayoutModel() {
        return Optional.ofNullable(this.layoutModel);
    }

    @Override
    public Optional<ValueProviderModel> getValueProviderModel() {
        return Optional.ofNullable(this.valueProviderModel);
    }
}

