/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.source;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.Stereotype;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.model.AbstractComponentModel;

public class ImmutableSourceModel
extends AbstractComponentModel
implements SourceModel {
    private final boolean hasResponse;
    private final SourceCallbackModel successCallback;
    private final SourceCallbackModel errorCallback;
    private final SourceCallbackModel terminateCallbackModel;
    private final Set<ErrorModel> errors;

    public ImmutableSourceModel(String name, String description, boolean hasResponse, List<ParameterGroupModel> parameterGroupModels, OutputModel output, OutputModel outputAttributes, Optional<SourceCallbackModel> successCallbackModel, Optional<SourceCallbackModel> errorCallbackModel, Optional<SourceCallbackModel> terminateCallbackModel, boolean requiresConnection, boolean transactional, boolean supportsStreaming, DisplayModel displayModel, Set<Stereotype> stereotypes, Set<ErrorModel> errors, Set<ModelProperty> modelProperties) {
        super(name, description, parameterGroupModels, output, outputAttributes, requiresConnection, transactional, supportsStreaming, displayModel, stereotypes, modelProperties);
        this.hasResponse = hasResponse;
        this.successCallback = successCallbackModel.orElse(null);
        this.errorCallback = errorCallbackModel.orElse(null);
        this.terminateCallbackModel = terminateCallbackModel.orElse(null);
        this.errors = errors;
    }

    @Override
    public boolean hasResponse() {
        return this.hasResponse;
    }

    @Override
    public Optional<SourceCallbackModel> getSuccessCallback() {
        return Optional.ofNullable(this.successCallback);
    }

    @Override
    public Optional<SourceCallbackModel> getErrorCallback() {
        return Optional.ofNullable(this.errorCallback);
    }

    @Override
    public Optional<SourceCallbackModel> getTerminateCallback() {
        return Optional.ofNullable(this.terminateCallbackModel);
    }

    @Override
    public Set<ErrorModel> getErrorModels() {
        return this.errors;
    }
}

