/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.operation.RouterModel;
import org.mule.runtime.api.meta.model.operation.ScopeModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ComponentModelVisitor;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.operation.ImmutableRouterModel;
import org.mule.runtime.extension.api.model.operation.ImmutableScopeModel;
import org.mule.runtime.extension.internal.persistence.KindEnrichedTypeAdapter;

public class OperationModelTypeAdapter
extends KindEnrichedTypeAdapter<OperationModel> {
    private static final String OPERATION_KIND = "operation";
    private static final String SCOPE_KIND = "scope";
    private static final String ROUTER_KIND = "router";

    public OperationModelTypeAdapter(TypeAdapterFactory typeAdapterFactory, Gson gson) {
        super(typeAdapterFactory, gson);
    }

    @Override
    protected String getKind(OperationModel value) {
        final Reference kind = new Reference();
        value.accept(new ComponentModelVisitor(){

            @Override
            public void visit(OperationModel operationModel) {
                kind.set(OperationModelTypeAdapter.OPERATION_KIND);
            }

            @Override
            public void visit(ScopeModel scopeModel) {
                kind.set(OperationModelTypeAdapter.SCOPE_KIND);
            }

            @Override
            public void visit(RouterModel routerModel) {
                kind.set(OperationModelTypeAdapter.ROUTER_KIND);
            }

            @Override
            public void visit(SourceModel sourceModel) {
            }
        });
        Preconditions.checkState(kind.get() != null, String.format("Cannot infer '%s' property while serializing model '%s''", "kind", value.getName()));
        return (String)kind.get();
    }

    @Override
    protected TypeAdapter<OperationModel> getDelegateAdapter(String kind) {
        Class<ImmutableOperationModel> operationClass;
        if (OPERATION_KIND.equals(kind)) {
            operationClass = ImmutableOperationModel.class;
        } else if (SCOPE_KIND.equals(kind)) {
            operationClass = ImmutableScopeModel.class;
        } else if (ROUTER_KIND.equals(kind)) {
            operationClass = ImmutableRouterModel.class;
        } else {
            throw new IllegalArgumentException("Invalid json. Operation specifies unknown kind: " + kind);
        }
        return this.gson.getDelegateAdapter(this.typeAdapterFactory, TypeToken.get(operationClass));
    }
}

