/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.message.request;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.HttpMessageBuilder;
import org.mule.runtime.http.api.domain.message.request.DefaultHttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public final class HttpRequestBuilder
extends HttpMessageBuilder<HttpRequestBuilder, HttpRequest> {
    private String path;
    private String uri;
    private String method = HttpConstants.Method.GET.name();
    private MultiMap<String, String> queryParams = new MultiMap();

    HttpRequestBuilder() {
    }

    public HttpRequestBuilder setUri(String uri) {
        int queryPos = uri.indexOf("?");
        this.path = queryPos > -1 ? uri.substring(0, queryPos) : uri;
        this.uri = uri;
        return this;
    }

    public HttpRequestBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestBuilder setMethod(HttpConstants.Method method) {
        this.method = method.name();
        return this;
    }

    public HttpRequestBuilder setHeaders(MultiMap<String, String> headersMap) {
        headersMap.keySet().forEach(key -> headersMap.getAll(key).forEach(value -> this.headers.put(key, value)));
        return this;
    }

    public HttpRequestBuilder setQueryParams(MultiMap<String, String> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    @Override
    public HttpRequest build() {
        Preconditions.checkNotNull(this.uri, "URI must be specified to create an HTTP request");
        return new DefaultHttpRequest(this.uri, this.path, this.method, this.headers.toImmutableMultiMap(), this.queryParams.toImmutableMultiMap(), this.entity);
    }
}

