/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.NotificationException;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeploymentInitException;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.DeploymentStopException;
import org.mule.runtime.deployment.model.api.InstallException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.classloader.DisposableClassLoader;
import org.mule.runtime.module.artifact.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationStartedSplashScreen;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationStatusMapper;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.service.ServiceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleApplication
implements Application {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ApplicationDescriptor descriptor;
    private final DomainRepository domainRepository;
    private final List<ArtifactPlugin> artifactPlugins;
    private final ServiceRepository serviceRepository;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final File location;
    private ApplicationStatus status;
    protected ArtifactClassLoader deploymentClassLoader;
    protected MuleContextListener muleContextListener;
    private ServerNotificationListener<MuleContextNotification> statusListener;
    private ArtifactContext artifactContext;
    private ApplicationPolicyProvider policyManager;

    public DefaultMuleApplication(ApplicationDescriptor descriptor, MuleDeployableArtifactClassLoader deploymentClassLoader, List<ArtifactPlugin> artifactPlugins, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, File location, ClassLoaderRepository classLoaderRepository, ApplicationPolicyProvider applicationPolicyProvider) {
        this.descriptor = descriptor;
        this.domainRepository = domainRepository;
        this.serviceRepository = serviceRepository;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.classLoaderRepository = classLoaderRepository;
        this.artifactPlugins = artifactPlugins;
        this.location = location;
        this.deploymentClassLoader = deploymentClassLoader;
        this.policyManager = applicationPolicyProvider;
        this.updateStatusFor("not in lifecycle");
        if (deploymentClassLoader == null) {
            throw new IllegalArgumentException("Classloader cannot be null");
        }
    }

    public void setMuleContextListener(MuleContextListener muleContextListener) {
        Preconditions.checkArgument(muleContextListener != null, "setMuleContextListener cannot be null");
        this.muleContextListener = muleContextListener;
    }

    @Override
    public void install() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash(String.format("New app '%s'", this.descriptor.getName())));
        }
        this.updateStatusFor("not in lifecycle");
        try {
            for (String configResourceAbsolutePath : this.descriptor.getAbsoluteResourcePaths()) {
                File configResource = new File(configResourceAbsolutePath);
                if (configResource.exists()) continue;
                String message = String.format("Config for app '%s' not found: %s", this.getArtifactName(), configResource);
                throw new InstallException(I18nMessageFactory.createStaticMessage(message));
            }
        }
        catch (Exception e) {
            this.setStatusToFailed();
            throw e;
        }
    }

    @Override
    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Domain getDomain() {
        return this.domainRepository.getDomain(this.descriptor.getDomain());
    }

    @Override
    public void start() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash(String.format("Starting app '%s'", this.descriptor.getName())));
        }
        try {
            this.artifactContext.getMuleContext().start();
            ClassUtils.withContextClassLoader(null, () -> {
                ApplicationStartedSplashScreen splashScreen = new ApplicationStartedSplashScreen();
                splashScreen.createMessage(this.descriptor);
                this.logger.info(splashScreen.toString());
            });
        }
        catch (Exception e) {
            this.setStatusToFailed();
            if (e instanceof MuleException) {
                this.logger.error(((MuleException)e).getDetailedMessage());
            } else {
                this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            }
            throw new DeploymentStartException(I18nMessageFactory.createStaticMessage(String.format("Error starting application '%s'", this.descriptor.getName())), (Throwable)e);
        }
    }

    @Override
    public void init() {
        this.doInit(false);
    }

    private void doInit(boolean lazy) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash(String.format("Initializing app '%s'", this.descriptor.getName())));
        }
        try {
            ArtifactContextBuilder artifactBuilder = ArtifactContextBuilder.newBuilder().setArtifactProperties(this.descriptor.getAppProperties()).setArtifactType(ArtifactType.APP).setArtifactName(this.descriptor.getName()).setArtifactInstallationDirectory(this.descriptor.getArtifactLocation()).setConfigurationFiles(this.descriptor.getAbsoluteResourcePaths()).setDefaultEncoding(this.descriptor.getEncoding()).setArtifactPlugins(this.artifactPlugins).setExecutionClassloader(this.deploymentClassLoader.getClassLoader()).setEnableLazyInit(lazy).setServiceRepository(this.serviceRepository).setExtensionModelLoaderRepository(this.extensionModelLoaderRepository).setClassLoaderRepository(this.classLoaderRepository).setArtifactDeclaration(this.descriptor.getArtifactDeclaration()).setPolicyProvider(this.policyManager);
            Domain domain = this.domainRepository.getDomain(this.descriptor.getDomain());
            if (domain.getMuleContext() != null) {
                artifactBuilder.serParenArtifact(domain);
            }
            if (this.muleContextListener != null) {
                artifactBuilder.setMuleContextListener(this.muleContextListener);
            }
            this.artifactContext = artifactBuilder.build();
            this.setMuleContext(this.artifactContext.getMuleContext());
        }
        catch (Exception e) {
            this.setStatusToFailed();
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentInitException(I18nMessageFactory.createStaticMessage(ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
    }

    @Override
    public void lazyInit() {
        this.doInit(true);
    }

    protected void setArtifactContext(ArtifactContext artifactContext) throws NotificationException {
        this.artifactContext = artifactContext;
        this.setMuleContext(this.artifactContext.getMuleContext());
    }

    private void setMuleContext(final MuleContext muleContext) throws NotificationException {
        this.statusListener = new MuleContextNotificationListener<MuleContextNotification>(){

            @Override
            public boolean isBlocking() {
                return false;
            }

            @Override
            public void onNotification(MuleContextNotification notification) {
                int action = notification.getAction();
                if (action == 102 || action == 104 || action == 106 || action == 108) {
                    DefaultMuleApplication.this.updateStatusFor(muleContext.getLifecycleManager().getCurrentPhase());
                }
            }
        };
        muleContext.registerListener(this.statusListener);
    }

    private void updateStatusFor(String phase) {
        this.status = ApplicationStatusMapper.getApplicationStatus(phase);
    }

    private void setStatusToFailed() {
        if (this.artifactContext != null) {
            this.artifactContext.getMuleContext().unregisterListener(this.statusListener);
        }
        this.status = ApplicationStatus.DEPLOYMENT_FAILED;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.artifactContext.getMuleContext();
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public ConnectivityTestingService getConnectivityTestingService() {
        return this.artifactContext.getConnectivityTestingService();
    }

    @Override
    public MetadataService getMetadataService() {
        return this.artifactContext.getMetadataService();
    }

    @Override
    public void dispose() {
        try {
            ClassLoader appCl = null;
            if (this.getArtifactClassLoader() != null) {
                appCl = this.getArtifactClassLoader().getClassLoader();
            }
            if (appCl != null) {
                Thread.currentThread().setContextClassLoader(appCl);
            }
            this.doDispose();
            if (appCl != null) {
                if (DefaultMuleApplication.isRegionClassLoaderMember(appCl)) {
                    ((DisposableClassLoader)((Object)appCl.getParent())).dispose();
                } else if (appCl instanceof DisposableClassLoader) {
                    ((DisposableClassLoader)((Object)appCl)).dispose();
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(null);
            this.deploymentClassLoader = null;
        }
    }

    private static boolean isRegionClassLoaderMember(ClassLoader classLoader) {
        return !(classLoader instanceof RegionClassLoader) && classLoader.getParent() instanceof RegionClassLoader;
    }

    @Override
    public String getArtifactName() {
        return this.descriptor.getName();
    }

    @Override
    public String getArtifactId() {
        return this.deploymentClassLoader.getArtifactId();
    }

    @Override
    public File[] getResourceFiles() {
        return this.descriptor.getConfigResourcesFile();
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.deploymentClassLoader;
    }

    @Override
    public void stop() {
        if (this.artifactContext == null || !this.artifactContext.getMuleContext().getLifecycleManager().isDirectTransition("stop")) {
            return;
        }
        if (this.artifactContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("Stopping app '%s' with no mule context", this.descriptor.getName()));
            }
            this.status = ApplicationStatus.STOPPED;
            return;
        }
        this.artifactContext.getMuleContext().getLifecycleManager().checkPhase("stop");
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(SplashScreen.miniSplash(String.format("Stopping app '%s'", this.descriptor.getName())));
            }
            this.artifactContext.getMuleContext().stop();
        }
        catch (MuleException e) {
            throw new DeploymentStopException(I18nMessageFactory.createStaticMessage(String.format("Error stopping application '%s'", this.descriptor.getName())), (Throwable)e);
        }
    }

    @Override
    public ApplicationStatus getStatus() {
        return this.status;
    }

    @Override
    public RegionClassLoader getRegionClassLoader() {
        ClassLoader parentClassLoader = this.deploymentClassLoader.getClassLoader().getParent();
        if (parentClassLoader instanceof RegionClassLoader) {
            return (RegionClassLoader)parentClassLoader;
        }
        throw new IllegalStateException("Application is not a region owner");
    }

    @Override
    public ApplicationPolicyProvider getPolicyManager() {
        return this.policyManager;
    }

    @Override
    public List<ArtifactPlugin> getArtifactPlugins() {
        return this.artifactPlugins;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.descriptor.getName(), Integer.toHexString(System.identityHashCode(this)));
    }

    protected void doDispose() {
        if (this.artifactContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("App '%s' never started, nothing to dispose of", this.descriptor.getName()));
            }
            return;
        }
        try {
            this.stop();
        }
        catch (DeploymentStopException e) {
            this.logger.error("Error stopping application", (Throwable)e);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SplashScreen.miniSplash(String.format("Disposing app '%s'", this.descriptor.getName())));
        }
        this.artifactContext.getMuleContext().dispose();
        this.artifactContext = null;
    }
}

