/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.InstallException;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;

public class DeployableArtifactWrapper<T extends DeployableArtifact<D>, D extends DeployableArtifactDescriptor>
implements DeployableArtifact<D> {
    private T delegate;

    protected DeployableArtifactWrapper(T artifact) throws IOException {
        this.delegate = artifact;
    }

    @Override
    public void dispose() {
        this.executeWithinArtifactClassLoader(() -> this.delegate.dispose());
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.delegate.getArtifactClassLoader();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.delegate.getMuleContext();
    }

    @Override
    public File getLocation() {
        return this.delegate.getLocation();
    }

    @Override
    public ConnectivityTestingService getConnectivityTestingService() {
        return this.getDelegate().getConnectivityTestingService();
    }

    @Override
    public MetadataService getMetadataService() {
        return this.getDelegate().getMetadataService();
    }

    @Override
    public List<ArtifactPlugin> getArtifactPlugins() {
        return this.delegate.getArtifactPlugins();
    }

    @Override
    public void init() {
        this.executeWithinArtifactClassLoader(() -> this.delegate.init());
    }

    @Override
    public void lazyInit() {
        this.getDelegate().lazyInit();
    }

    @Override
    public void install() throws InstallException {
        this.executeWithinArtifactClassLoader(() -> this.delegate.install());
    }

    @Override
    public String getArtifactName() {
        return this.delegate.getArtifactName();
    }

    @Override
    public String getArtifactId() {
        return this.delegate.getArtifactId();
    }

    @Override
    public D getDescriptor() {
        return (D)((DeployableArtifactDescriptor)this.delegate.getDescriptor());
    }

    @Override
    public File[] getResourceFiles() {
        return this.delegate.getResourceFiles();
    }

    @Override
    public void start() throws DeploymentStartException {
        this.executeWithinArtifactClassLoader(() -> this.delegate.start());
    }

    @Override
    public void stop() {
        this.executeWithinArtifactClassLoader(() -> this.delegate.stop());
    }

    private void executeWithinArtifactClassLoader(ArtifactAction artifactAction) {
        ClassLoader classLoader = this.getArtifactClassLoader() != null ? this.getArtifactClassLoader().getClassLoader() : Thread.currentThread().getContextClassLoader();
        ClassUtils.withContextClassLoader(classLoader, artifactAction::execute);
    }

    public String getAppName() {
        return this.getArtifactName();
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getName(), this.delegate);
    }

    public T getDelegate() {
        return this.delegate;
    }

    private static interface ArtifactAction {
        public void execute();
    }
}

